/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;

class DynamicRecordCheck
implements RecordCheck<DynamicRecord, ConsistencyReport.DynamicConsistencyReport>,
ComparativeRecordChecker<DynamicRecord, DynamicRecord, ConsistencyReport.DynamicConsistencyReport> {
    private final int blockSize;
    private final DynamicStore dereference;
    private final RecordStore<DynamicRecord> store;

    DynamicRecordCheck(RecordStore<DynamicRecord> store, DynamicStore dereference) {
        this.blockSize = store.getRecordSize() - store.getRecordHeaderSize();
        this.dereference = dereference;
        this.store = store;
    }

    @Override
    public void checkChange(DynamicRecord oldRecord, DynamicRecord newRecord, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> engine, DiffRecordAccess records) {
        DynamicRecord next;
        this.check(newRecord, engine, (RecordAccess)records);
        if (!(!oldRecord.inUse() || Record.NO_NEXT_BLOCK.is(oldRecord.getNextBlock()) || newRecord.inUse() && oldRecord.getNextBlock() == newRecord.getNextBlock() || (next = this.dereference.changed(records, oldRecord.getNextBlock())) != null)) {
            engine.report().nextNotUpdated();
        }
    }

    @Override
    public void check(DynamicRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> engine, RecordAccess records) {
        if (!record.inUse()) {
            return;
        }
        if (record.getLength() == 0) {
            engine.report().emptyBlock();
        } else if (record.getLength() < 0) {
            engine.report().invalidLength();
        }
        if (!Record.NO_NEXT_BLOCK.is(record.getNextBlock())) {
            if (record.getNextBlock() == record.getId()) {
                engine.report().selfReferentialNext();
            } else {
                engine.comparativeCheck(this.dereference.lookup(records, record.getNextBlock()), this);
            }
            if (record.getLength() < this.blockSize) {
                engine.report().recordNotFullReferencesNext();
            }
        }
    }

    @Override
    public void checkReference(DynamicRecord record, DynamicRecord next, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> engine, RecordAccess records) {
        if (!next.inUse()) {
            engine.report().nextNotInUse(next);
        } else if (next.getLength() <= 0) {
            engine.report().emptyNextBlock(next);
        }
    }
}

