/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import java.io.PrintWriter;
import java.util.HashSet;
import org.neo4j.consistency.repair.RecordSet;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class NodePropertiesReporter {
    private final GraphDatabaseService database;

    public NodePropertiesReporter(GraphDatabaseService database) {
        this.database = database;
    }

    public void reportNodeProperties(PrintWriter writer, RecordSet<RelationshipRecord> relationshipRecords) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        for (RelationshipRecord relationshipRecord : relationshipRecords) {
            nodeIds.add(relationshipRecord.getFirstNode());
            nodeIds.add(relationshipRecord.getSecondNode());
        }
        for (Long nodeId : nodeIds) {
            this.reportNodeProperties(writer, nodeId);
        }
    }

    private void reportNodeProperties(PrintWriter writer, Long nodeId) {
        try {
            Node node = this.database.getNodeById(nodeId.longValue());
            writer.println(String.format("Properties for node %d", nodeId));
            for (String propertyKey : node.getPropertyKeys()) {
                writer.println(String.format("    %s = %s", propertyKey, node.getProperty(propertyKey)));
            }
        }
        catch (Exception e) {
            writer.println(String.format("Failed to report properties for node %d:", nodeId));
            e.printStackTrace(writer);
        }
    }
}

