/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store;

import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.DiffStore;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.consistency.store.DirectRecordReference;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class DirectDiffRecordAccess
extends DirectRecordAccess
implements DiffRecordAccess {
    public DirectDiffRecordAccess(DiffStore access) {
        super(access);
    }

    @Override
    public RecordReference<NeoStoreRecord> graph() {
        return new DirectRecordReference<NeoStoreRecord>(((DiffStore)this.access).getMasterRecord(), this);
    }

    @Override
    public RecordReference<NodeRecord> previousNode(long id) {
        return this.referenceTo(this.access.getNodeStore(), id);
    }

    @Override
    public RecordReference<RelationshipRecord> previousRelationship(long id) {
        return this.referenceTo(this.access.getRelationshipStore(), id);
    }

    @Override
    public RecordReference<PropertyRecord> previousProperty(long id) {
        return this.referenceTo(this.access.getPropertyStore(), id);
    }

    @Override
    public DynamicRecord changedSchema(long id) {
        return (DynamicRecord)((DiffStore)this.access).getSchemaStore().getChangedRecord(id);
    }

    @Override
    public NodeRecord changedNode(long id) {
        return (NodeRecord)((DiffStore)this.access).getNodeStore().getChangedRecord(id);
    }

    @Override
    public RelationshipRecord changedRelationship(long id) {
        return (RelationshipRecord)((DiffStore)this.access).getRelationshipStore().getChangedRecord(id);
    }

    @Override
    public PropertyRecord changedProperty(long id) {
        return (PropertyRecord)((DiffStore)this.access).getPropertyStore().getChangedRecord(id);
    }

    @Override
    public DynamicRecord changedString(long id) {
        return (DynamicRecord)((DiffStore)this.access).getStringStore().getChangedRecord(id);
    }

    @Override
    public DynamicRecord changedArray(long id) {
        return (DynamicRecord)((DiffStore)this.access).getArrayStore().getChangedRecord(id);
    }

    @Override
    public RecordReference<NeoStoreRecord> previousGraph() {
        return new DirectRecordReference<NeoStoreRecord>(this.access.getRawNeoStore().asRecord(), this);
    }

    @Override
    <RECORD extends AbstractBaseRecord> RecordReference<RECORD> referenceTo(RecordStore<RECORD> store, long id) {
        return new DirectDiffRecordReference<AbstractBaseRecord>(store.forceGetRecord(id), store.forceGetRaw(id), this);
    }

    private static class DirectDiffRecordReference<RECORD extends AbstractBaseRecord>
    extends DirectRecordReference<RECORD> {
        private final RECORD oldRecord;

        DirectDiffRecordReference(RECORD newRecord, RECORD oldRecord, RecordAccess records) {
            super(newRecord, records);
            this.oldRecord = oldRecord;
        }

        @Override
        public void dispatch(PendingReferenceCheck<RECORD> reporter) {
            reporter.checkDiffReference(this.oldRecord, this.record, this.records);
        }
    }
}

