/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.ConsistencyCheckTool;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.legacy.consistency.ConsistencyCheckTool;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactoryState;
import org.neo4j.udc.UsageDataKeys;

@RunWith(value=Parameterized.class)
public class ConsistencyCheckToolTest {
    private final boolean useLegacyChecker;
    @Rule
    public TargetDirectory.TestDirectory storeDirectory = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Parameterized.Parameters(name="Experimental:{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{Boolean.FALSE});
        data.add(new Object[]{Boolean.TRUE});
        return data;
    }

    public ConsistencyCheckToolTest(boolean useLegacyChecker) {
        this.useLegacyChecker = useLegacyChecker;
    }

    @Test
    public void runsConsistencyCheck() throws Exception {
        Assume.assumeFalse((String)"This test runs with mocked ConsistencyCheckService, doesn't work with the legacy checker since it creates its own", (boolean)this.useLegacyChecker);
        File storeDir = this.storeDirectory.directory();
        String[] args = new String[]{storeDir.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        PrintStream systemError = (PrintStream)Mockito.mock(PrintStream.class);
        this.runConsistencyCheckToolWith(service, systemError, args);
        ((ConsistencyCheckService)Mockito.verify((Object)service)).runFullConsistencyCheck((File)Matchers.eq((Object)storeDir), (Config)Matchers.any(Config.class), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.anyBoolean());
    }

    @Test
    public void appliesDefaultTuningConfigurationForConsistencyChecker() throws Exception {
        Assume.assumeFalse((String)"This test runs with mocked ConsistencyCheckService, doesn't work with the legacy checker since it creates its own", (boolean)this.useLegacyChecker);
        File storeDir = this.storeDirectory.directory();
        String[] args = new String[]{storeDir.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        this.runConsistencyCheckToolWith(service, systemOut, args);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        ((ConsistencyCheckService)Mockito.verify((Object)service)).runFullConsistencyCheck((File)Matchers.eq((Object)storeDir), (Config)config.capture(), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.anyBoolean());
        Assert.assertFalse((boolean)((Boolean)((Config)config.getValue()).get(ConsistencyCheckSettings.consistency_check_property_owners)));
    }

    @Test
    public void passesOnConfigurationIfProvided() throws Exception {
        Assume.assumeFalse((String)"This test runs with mocked ConsistencyCheckService, doesn't work with the legacy checker since it creates its own", (boolean)this.useLegacyChecker);
        File storeDir = this.storeDirectory.directory();
        File propertyFile = this.storeDirectory.file("neo4j.properties");
        Properties properties = new Properties();
        properties.setProperty(ConsistencyCheckSettings.consistency_check_property_owners.name(), "true");
        properties.store(new FileWriter(propertyFile), null);
        String[] args = new String[]{storeDir.getPath(), "-config", propertyFile.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        this.runConsistencyCheckToolWith(service, systemOut, args);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        ((ConsistencyCheckService)Mockito.verify((Object)service)).runFullConsistencyCheck((File)Matchers.eq((Object)storeDir), (Config)config.capture(), (ProgressMonitorFactory)Matchers.any(ProgressMonitorFactory.class), (LogProvider)Matchers.any(LogProvider.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), Matchers.anyBoolean());
        Assert.assertTrue((boolean)((Boolean)((Config)config.getValue()).get(ConsistencyCheckSettings.consistency_check_property_owners)));
    }

    @Test
    public void exitWithFailureIndicatingCorrectUsageIfNoArgumentsSupplied() throws Exception {
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        String[] args = new String[]{};
        PrintStream systemError = (PrintStream)Mockito.mock(PrintStream.class);
        try {
            this.runConsistencyCheckToolWith(service, systemError, args);
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConsistencyCheckTool.ToolFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"USAGE:"));
        }
    }

    @Test
    public void exitWithFailureIfConfigSpecifiedButPropertiesFileDoesNotExist() throws Exception {
        File propertyFile = this.storeDirectory.file("nonexistent_file");
        String[] args = new String[]{this.storeDirectory.directory().getPath(), "-config", propertyFile.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        PrintStream systemOut = (PrintStream)Mockito.mock(PrintStream.class);
        try {
            this.runConsistencyCheckToolWith(service, systemOut, args);
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConsistencyCheckTool.ToolFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not read configuration properties file"));
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{service});
    }

    @Test
    public void shouldExecuteRecoveryWhenStoreWasNonCleanlyShutdown() throws Exception {
        this.createGraphDbAndKillIt();
        Monitors monitors = new Monitors();
        Recovery.Monitor listener = (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class);
        monitors.addMonitorListener((Object)listener, new String[0]);
        this.runConsistencyCheckToolWith(monitors, (ConsistencyCheckTool.ExitHandle)Mockito.mock(ConsistencyCheckTool.ExitHandle.class), (FileSystemAbstraction)this.fs.get(), "-recovery", this.storeDirectory.graphDbDir().getAbsolutePath());
        ((Recovery.Monitor)Mockito.verify((Object)listener)).recoveryRequired((LogPosition)Matchers.any(LogPosition.class));
        ((Recovery.Monitor)Mockito.verify((Object)listener)).recoveryCompleted(Matchers.anyInt());
    }

    @Test
    public void shouldExitWhenRecoveryNeededButRecoveryFalseOptionSpecified() throws Exception {
        File storeDir = this.storeDirectory.graphDbDir();
        EphemeralFileSystemAbstraction fileSystem = this.createDataBaseWithStateThatNeedsRecovery(storeDir);
        Monitors monitors = new Monitors();
        PhysicalLogFile.Monitor listener = (PhysicalLogFile.Monitor)Mockito.mock(PhysicalLogFile.Monitor.class);
        monitors.addMonitorListener((Object)listener, new String[0]);
        ConsistencyCheckTool.ExitHandle exitHandle = (ConsistencyCheckTool.ExitHandle)Mockito.mock(ConsistencyCheckTool.ExitHandle.class);
        ((ConsistencyCheckTool.ExitHandle)Mockito.doThrow((Throwable)new TransientDatabaseFailureException("Recovery required")).when((Object)exitHandle)).pull();
        try {
            this.runConsistencyCheckToolWith(monitors, exitHandle, (FileSystemAbstraction)fileSystem, "-recovery=false", storeDir.getAbsolutePath());
            Assert.fail((String)"Recovery should be required and exit pull should be called.");
        }
        catch (TransientDatabaseFailureException transientDatabaseFailureException) {
            // empty catch block
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{listener});
        ((ConsistencyCheckTool.ExitHandle)Mockito.verify((Object)exitHandle)).pull();
    }

    private EphemeralFileSystemAbstraction createDataBaseWithStateThatNeedsRecovery(File storeDir) {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fileSystem).newImpermanentDatabase(storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        EphemeralFileSystemAbstraction snapshot = fileSystem.snapshot();
        db.shutdown();
        return snapshot;
    }

    private void createGraphDbAndKillIt() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get()).newImpermanentDatabaseBuilder(this.storeDirectory.graphDbDir()).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{DynamicLabel.label((String)"FOO")});
            db.createNode(new Label[]{DynamicLabel.label((String)"BAR")});
            tx.success();
        }
        this.fs.snapshot(EphemeralFileSystemRule.shutdownDbAction((GraphDatabaseService)db));
    }

    private void runConsistencyCheckToolWith(Monitors monitors, ConsistencyCheckTool.ExitHandle exitHandle, FileSystemAbstraction fileSystem, String ... args) throws IOException, ConsistencyCheckTool.ToolFailureException {
        GraphDatabaseFactory graphDbFactory = new NonEphemeralImpermanentDatabaseFactory((FileSystemAbstraction)this.fs.get()).setMonitors(monitors);
        new ConsistencyCheckTool((ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class), graphDbFactory, fileSystem, (PrintStream)Mockito.mock(PrintStream.class), exitHandle).run(this.augment(args));
    }

    private String[] augment(String[] args) {
        return (String[])ArrayUtil.concat((Object)("-use-legacy-checker=" + this.useLegacyChecker), (Object[])args);
    }

    private void runConsistencyCheckToolWith(ConsistencyCheckService consistencyCheckService, PrintStream systemError, String ... args) throws ConsistencyCheckTool.ToolFailureException, IOException {
        new ConsistencyCheckTool(consistencyCheckService, new GraphDatabaseFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), systemError, ConsistencyCheckTool.ExitHandle.SYSTEM_EXIT).run(this.augment(args));
    }

    private static class NonEphemeralImpermanentDatabaseFactory
    extends TestGraphDatabaseFactory {
        private final FileSystemAbstraction consistencyCheckerFileSystem;

        public NonEphemeralImpermanentDatabaseFactory(FileSystemAbstraction consistencyCheckerFileSystem) {
            this.consistencyCheckerFileSystem = consistencyCheckerFileSystem;
        }

        protected GraphDatabaseBuilder.DatabaseCreator createImpermanentDatabaseCreator(File storeDir, TestGraphDatabaseFactoryState state) {
            return new NonEphemeralImpermanentDatabaseCreator(storeDir, state, this.consistencyCheckerFileSystem);
        }

        public GraphDatabaseService newEmbeddedDatabase(File storeDir) {
            return this.newImpermanentDatabase(storeDir);
        }
    }

    private static class NonEphemeralImpermanentDatabaseCreator
    implements GraphDatabaseBuilder.DatabaseCreator {
        private final File storeDir;
        private final TestGraphDatabaseFactoryState state;
        private final FileSystemAbstraction consistencyCheckerFileSystem;

        NonEphemeralImpermanentDatabaseCreator(File storeDir, TestGraphDatabaseFactoryState state, FileSystemAbstraction consistencyCheckerFileSystem) {
            this.storeDir = storeDir;
            this.state = state;
            this.consistencyCheckerFileSystem = consistencyCheckerFileSystem;
        }

        public GraphDatabaseService newDatabase(Map<String, String> config) {
            return new ImpermanentGraphDatabase(this.storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)this.state.databaseDependencies())){

                protected void create(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                    new NonEphemeralImpermanentFacadeFactory(NonEphemeralImpermanentDatabaseCreator.this.consistencyCheckerFileSystem).newFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
                }
            };
        }
    }

    private static class NonEphemeralImpermanentFacadeFactory
    extends CommunityFacadeFactory {
        private final FileSystemAbstraction consistencyCheckerFileSystem;

        NonEphemeralImpermanentFacadeFactory(FileSystemAbstraction consistencyCheckerFileSystem) {
            this.consistencyCheckerFileSystem = consistencyCheckerFileSystem;
        }

        protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade, UsageDataKeys.OperationalMode operationalMode) {
            params.put(GraphDatabaseFacadeFactory.Configuration.ephemeral.name(), "false");
            return new PlatformModule(storeDir, params, dependencies, graphDatabaseFacade, operationalMode){

                protected FileSystemAbstraction createFileSystemAbstraction() {
                    return NonEphemeralImpermanentFacadeFactory.this.consistencyCheckerFileSystem;
                }
            };
        }
    }
}

