/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.NodeDynamicLabelOrphanChainStartCheck;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PreAllocatedRecords;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class NodeDynamicLabelOrphanChainStartCheckTest
extends RecordCheckTestBase<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport, NodeDynamicLabelOrphanChainStartCheck> {
    public static final PreAllocatedRecords RECORD_ALLOCATOR = new PreAllocatedRecords(66);

    public NodeDynamicLabelOrphanChainStartCheckTest() {
        super(new NodeDynamicLabelOrphanChainStartCheck(), ConsistencyReport.DynamicLabelConsistencyReport.class, new int[0], new MultiPassStore[0]);
    }

    @Test
    @Ignore(value="2013-07-17 Revisit once we store sorted label ids")
    public void shouldReportOrphanRecordsThatAreNotFirst() throws Exception {
        DynamicRecord record0 = this.addNodeDynamicLabels(NodeDynamicLabelOrphanChainStartCheckTest.inUse(new DynamicRecord(0L)));
        DynamicRecord record1 = this.addNodeDynamicLabels(NodeDynamicLabelOrphanChainStartCheckTest.inUse(new DynamicRecord(1L)));
        DynamicRecord record2 = this.addNodeDynamicLabels(NodeDynamicLabelOrphanChainStartCheckTest.inUse(new DynamicRecord(2L)));
        long[] longs = new long[130];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = i;
        }
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)longs, (Iterator)IteratorUtil.iterator((Object[])new DynamicRecord[]{record0, record1, record2}), (DynamicRecordAllocator)RECORD_ALLOCATOR);
        record0.setInUse(false);
        ConsistencyReport.DynamicLabelConsistencyReport report = (ConsistencyReport.DynamicLabelConsistencyReport)this.check(record1);
        ((ConsistencyReport.DynamicLabelConsistencyReport)Mockito.verify((Object)report)).orphanDynamicLabelRecord();
    }

    @Test
    public void shouldReportMissingOwnerId() throws Exception {
        DynamicRecord nodeDynamicLabelRecord = NodeDynamicLabelOrphanChainStartCheckTest.inUse(new DynamicRecord(0L));
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)new long[0], (Iterator)IteratorUtil.iterator((Object)nodeDynamicLabelRecord), (DynamicRecordAllocator)RECORD_ALLOCATOR);
        ConsistencyReport.DynamicLabelConsistencyReport report = (ConsistencyReport.DynamicLabelConsistencyReport)this.check(nodeDynamicLabelRecord);
        ((ConsistencyReport.DynamicLabelConsistencyReport)Mockito.verify((Object)report)).orphanDynamicLabelRecord();
    }

    @Test
    public void shouldReportOwningNodeRecordNotInUse() throws Exception {
        NodeRecord nodeRecord = NodeDynamicLabelOrphanChainStartCheckTest.notInUse(new NodeRecord(12L, false, -1L, -1L));
        this.add(nodeRecord);
        DynamicRecord nodeDynamicLabelRecord = NodeDynamicLabelOrphanChainStartCheckTest.inUse(new DynamicRecord(0L));
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)new long[]{12L}, (Iterator)IteratorUtil.iterator((Object)nodeDynamicLabelRecord), (DynamicRecordAllocator)RECORD_ALLOCATOR);
        ConsistencyReport.DynamicLabelConsistencyReport report = (ConsistencyReport.DynamicLabelConsistencyReport)this.check(nodeDynamicLabelRecord);
        ((ConsistencyReport.DynamicLabelConsistencyReport)Mockito.verify((Object)report)).orphanDynamicLabelRecordDueToInvalidOwner(nodeRecord);
    }

    @Test
    public void shouldReportOwningNodeRecordNotPointingBack() throws Exception {
        long nodeId = 12L;
        ArrayList validLabelRecords = new ArrayList();
        DynamicArrayStore.allocateFromNumbers(validLabelRecords, (Object)new long[]{nodeId}, (Iterator)IteratorUtil.iterator((Object)NodeDynamicLabelOrphanChainStartCheckTest.inUse(new DynamicRecord(0L))), (DynamicRecordAllocator)RECORD_ALLOCATOR);
        ArrayList fakePointedToRecords = new ArrayList();
        DynamicArrayStore.allocateFromNumbers(fakePointedToRecords, (Object)new long[]{nodeId}, (Iterator)IteratorUtil.iterator((Object)NodeDynamicLabelOrphanChainStartCheckTest.inUse(new DynamicRecord(1L))), (DynamicRecordAllocator)RECORD_ALLOCATOR);
        NodeRecord nodeRecord = NodeDynamicLabelOrphanChainStartCheckTest.inUse(new NodeRecord(nodeId, false, -1L, -1L));
        nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(fakePointedToRecords), fakePointedToRecords);
        this.add(nodeRecord);
        ConsistencyReport.DynamicLabelConsistencyReport report = (ConsistencyReport.DynamicLabelConsistencyReport)this.check((AbstractBaseRecord)IteratorUtil.single(validLabelRecords.iterator()));
        ((ConsistencyReport.DynamicLabelConsistencyReport)Mockito.verify((Object)report)).orphanDynamicLabelRecordDueToInvalidOwner(nodeRecord);
    }
}

