/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.PropertyKeyTokenRecordCheck;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;

public class PropertyKeyTokenRecordCheckTest
extends RecordCheckTestBase<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport, PropertyKeyTokenRecordCheck> {
    public PropertyKeyTokenRecordCheckTest() {
        super(new PropertyKeyTokenRecordCheck(), ConsistencyReport.PropertyKeyTokenConsistencyReport.class, new int[0], new MultiPassStore[0]);
    }

    @Test
    public void shouldNotReportAnythingForRecordNotInUse() throws Exception {
        PropertyKeyTokenRecord key = PropertyKeyTokenRecordCheckTest.notInUse(new PropertyKeyTokenRecord(42));
        ConsistencyReport.PropertyKeyTokenConsistencyReport report = (ConsistencyReport.PropertyKeyTokenConsistencyReport)this.check(key);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldNotReportAnythingForRecordThatDoesNotReferenceADynamicBlock() throws Exception {
        PropertyKeyTokenRecord key = PropertyKeyTokenRecordCheckTest.inUse(new PropertyKeyTokenRecord(42));
        ConsistencyReport.PropertyKeyTokenConsistencyReport report = (ConsistencyReport.PropertyKeyTokenConsistencyReport)this.check(key);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportDynamicBlockNotInUse() throws Exception {
        PropertyKeyTokenRecord key = PropertyKeyTokenRecordCheckTest.inUse(new PropertyKeyTokenRecord(42));
        DynamicRecord name = this.addKeyName(PropertyKeyTokenRecordCheckTest.notInUse(new DynamicRecord(6L)));
        key.setNameId((int)name.getId());
        ConsistencyReport.PropertyKeyTokenConsistencyReport report = (ConsistencyReport.PropertyKeyTokenConsistencyReport)this.check(key);
        ((ConsistencyReport.PropertyKeyTokenConsistencyReport)Mockito.verify((Object)report)).nameBlockNotInUse(name);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportEmptyName() throws Exception {
        PropertyKeyTokenRecord key = PropertyKeyTokenRecordCheckTest.inUse(new PropertyKeyTokenRecord(42));
        DynamicRecord name = this.addKeyName(PropertyKeyTokenRecordCheckTest.inUse(new DynamicRecord(6L)));
        key.setNameId((int)name.getId());
        ConsistencyReport.PropertyKeyTokenConsistencyReport report = (ConsistencyReport.PropertyKeyTokenConsistencyReport)this.check(key);
        ((ConsistencyReport.PropertyKeyTokenConsistencyReport)Mockito.verify((Object)report)).emptyName(name);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }
}

