/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.PropertyRecordCheck;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;

public class PropertyRecordCheckTest
extends RecordCheckTestBase<PropertyRecord, ConsistencyReport.PropertyConsistencyReport, PropertyRecordCheck> {
    public PropertyRecordCheckTest() {
        super(new PropertyRecordCheck(), ConsistencyReport.PropertyConsistencyReport.class, new int[0], new MultiPassStore[0]);
    }

    @Test
    public void shouldNotReportAnythingForPropertyRecordNotInUse() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.notInUse(new PropertyRecord(42L));
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldNotReportAnythingForPropertyWithoutBlocksThatDoesNotReferenceAnyOtherRecords() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportPropertyKeyNotInUse() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyKeyTokenRecord key = this.add(PropertyRecordCheckTest.notInUse(new PropertyKeyTokenRecord(0)));
        PropertyBlock block = PropertyRecordCheckTest.propertyBlock(key, PropertyType.INT, 0L);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).keyNotInUse(block, key);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportPreviousPropertyNotInUse() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyRecord prev = this.add(PropertyRecordCheckTest.notInUse(new PropertyRecord(51L)));
        property.setPrevProp(prev.getId());
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).prevNotInUse(prev);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportNextPropertyNotInUse() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyRecord next = this.add(PropertyRecordCheckTest.notInUse(new PropertyRecord(51L)));
        property.setNextProp(next.getId());
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).nextNotInUse(next);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportPreviousPropertyNotReferringBack() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyRecord prev = this.add(PropertyRecordCheckTest.inUse(new PropertyRecord(51L)));
        property.setPrevProp(prev.getId());
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).previousDoesNotReferenceBack(prev);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportNextPropertyNotReferringBack() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyRecord next = this.add(PropertyRecordCheckTest.inUse(new PropertyRecord(51L)));
        property.setNextProp(next.getId());
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).nextDoesNotReferenceBack(next);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportStringRecordNotInUse() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyKeyTokenRecord key = this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        DynamicRecord value = this.add(PropertyRecordCheckTest.notInUse(PropertyRecordCheckTest.string(new DynamicRecord(1001L))));
        PropertyBlock block = PropertyRecordCheckTest.propertyBlock(key, value);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).stringNotInUse(block, value);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportArrayRecordNotInUse() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyKeyTokenRecord key = this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        DynamicRecord value = this.add(PropertyRecordCheckTest.notInUse(PropertyRecordCheckTest.array(new DynamicRecord(1001L))));
        PropertyBlock block = PropertyRecordCheckTest.propertyBlock(key, value);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).arrayNotInUse(block, value);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportEmptyStringRecord() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyKeyTokenRecord key = this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        DynamicRecord value = this.add(PropertyRecordCheckTest.inUse(PropertyRecordCheckTest.string(new DynamicRecord(1001L))));
        PropertyBlock block = PropertyRecordCheckTest.propertyBlock(key, value);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).stringEmpty(block, value);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportEmptyArrayRecord() throws Exception {
        PropertyRecord property = PropertyRecordCheckTest.inUse(new PropertyRecord(42L));
        PropertyKeyTokenRecord key = this.add(PropertyRecordCheckTest.inUse(new PropertyKeyTokenRecord(6)));
        DynamicRecord value = this.add(PropertyRecordCheckTest.inUse(PropertyRecordCheckTest.array(new DynamicRecord(1001L))));
        PropertyBlock block = PropertyRecordCheckTest.propertyBlock(key, value);
        property.addPropertyBlock(block);
        ConsistencyReport.PropertyConsistencyReport report = (ConsistencyReport.PropertyConsistencyReport)this.check(property);
        ((ConsistencyReport.PropertyConsistencyReport)Mockito.verify((Object)report)).arrayEmpty(block, value);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }
}

