/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;

public class TransactionWriter {
    private final List<Command> commands = new ArrayList<Command>();

    public TransactionRepresentation representation(byte[] additionalHeader, int masterId, int authorId, long startTime, long lastCommittedTx, long committedTime) {
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(this.commands);
        representation.setHeader(additionalHeader, masterId, authorId, startTime, lastCommittedTx, committedTime, -1);
        return representation;
    }

    public void propertyKey(int id, String key, int ... dynamicIds) {
        Command.PropertyKeyTokenCommand command = new Command.PropertyKeyTokenCommand();
        command.init((TokenRecord)TransactionWriter.withName(new PropertyKeyTokenRecord(id), dynamicIds, key));
        this.addCommand((Command)command);
    }

    public void label(int id, String name, int ... dynamicIds) {
        Command.LabelTokenCommand command = new Command.LabelTokenCommand();
        command.init((TokenRecord)TransactionWriter.withName(new LabelTokenRecord(id), dynamicIds, name));
        this.addCommand((Command)command);
    }

    public void relationshipType(int id, String label, int ... dynamicIds) {
        Command.RelationshipTypeTokenCommand command = new Command.RelationshipTypeTokenCommand();
        command.init((TokenRecord)TransactionWriter.withName(new RelationshipTypeTokenRecord(id), dynamicIds, label));
        this.addCommand((Command)command);
    }

    public void update(NeoStoreRecord record) {
        Command.NeoStoreCommand command = new Command.NeoStoreCommand();
        command.init(record);
        this.addCommand((Command)command);
    }

    public void update(LabelTokenRecord labelToken) {
        Command.LabelTokenCommand command = new Command.LabelTokenCommand();
        command.init((TokenRecord)labelToken);
        this.addCommand((Command)command);
    }

    private void addCommand(Command command) {
        this.commands.add(command);
    }

    public void create(NodeRecord node) {
        node.setCreated();
        this.update(new NodeRecord(node.getId(), false, (long)Record.NO_PREV_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue()), node);
    }

    public void create(LabelTokenRecord labelToken) {
        labelToken.setCreated();
        this.update(labelToken);
    }

    public void create(PropertyKeyTokenRecord token) {
        token.setCreated();
        this.update(token);
    }

    public void create(RelationshipGroupRecord group) {
        group.setCreated();
        this.update(group);
    }

    public void update(NodeRecord before, NodeRecord node) {
        node.setInUse(true);
        this.add(before, node);
    }

    public void update(PropertyKeyTokenRecord token) {
        token.setInUse(true);
        this.add(token);
    }

    public void delete(NodeRecord node) {
        node.setInUse(false);
        this.add(node, new NodeRecord(node.getId(), false, (long)Record.NO_PREV_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue()));
    }

    public void create(RelationshipRecord relationship) {
        relationship.setCreated();
        this.update(relationship);
    }

    public void delete(RelationshipGroupRecord group) {
        group.setInUse(false);
        this.add(group);
    }

    public void createSchema(Collection<DynamicRecord> beforeRecord, Collection<DynamicRecord> afterRecord, SchemaRule rule) {
        for (DynamicRecord record : afterRecord) {
            record.setCreated();
        }
        this.updateSchema(beforeRecord, afterRecord, rule);
    }

    public void updateSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords, SchemaRule rule) {
        for (DynamicRecord record : afterRecords) {
            record.setInUse(true);
        }
        this.addSchema(beforeRecords, afterRecords, rule);
    }

    public void update(RelationshipRecord relationship) {
        relationship.setInUse(true);
        this.add(relationship);
    }

    public void update(RelationshipGroupRecord group) {
        group.setInUse(true);
        this.add(group);
    }

    public void delete(RelationshipRecord relationship) {
        relationship.setInUse(false);
        this.add(relationship);
    }

    public void create(PropertyRecord property) {
        property.setCreated();
        PropertyRecord before = new PropertyRecord(property.getLongId());
        if (property.isNodeSet()) {
            before.setNodeId(property.getNodeId());
        }
        if (property.isRelSet()) {
            before.setRelId(property.getRelId());
        }
        this.update(before, property);
    }

    public void update(PropertyRecord before, PropertyRecord after) {
        after.setInUse(true);
        this.add(before, after);
    }

    public void delete(PropertyRecord before, PropertyRecord after) {
        after.setInUse(false);
        this.add(before, after);
    }

    private void addSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords, SchemaRule rule) {
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand();
        command.init(beforeRecords, afterRecords, rule);
        this.addCommand((Command)command);
    }

    public void add(NodeRecord before, NodeRecord after) {
        Command.NodeCommand command = new Command.NodeCommand();
        command.init(before, after);
        this.addCommand((Command)command);
    }

    public void add(RelationshipRecord relationship) {
        Command.RelationshipCommand command = new Command.RelationshipCommand();
        command.init(relationship);
        this.addCommand((Command)command);
    }

    public void add(RelationshipGroupRecord group) {
        Command.RelationshipGroupCommand command = new Command.RelationshipGroupCommand();
        command.init(group);
        this.addCommand((Command)command);
    }

    public void add(PropertyRecord before, PropertyRecord property) {
        Command.PropertyCommand command = new Command.PropertyCommand();
        command.init(before, property);
        this.addCommand((Command)command);
    }

    public void add(RelationshipTypeTokenRecord record) {
        Command.RelationshipTypeTokenCommand command = new Command.RelationshipTypeTokenCommand();
        command.init((TokenRecord)record);
        this.addCommand((Command)command);
    }

    public void add(PropertyKeyTokenRecord record) {
        Command.PropertyKeyTokenCommand command = new Command.PropertyKeyTokenCommand();
        command.init((TokenRecord)record);
        this.addCommand((Command)command);
    }

    public void add(NeoStoreRecord record) {
        Command.NeoStoreCommand command = new Command.NeoStoreCommand();
        command.init(record);
        this.addCommand((Command)command);
    }

    public void incrementNodeCount(int labelId, long delta) {
        this.addCommand((Command)new Command.NodeCountsCommand().init(labelId, delta));
    }

    public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
        this.addCommand((Command)new Command.RelationshipCountsCommand().init(startLabelId, typeId, endLabelId, delta));
    }

    private static <T extends TokenRecord> T withName(T record, int[] dynamicIds, String name) {
        if (dynamicIds == null || dynamicIds.length == 0) {
            throw new IllegalArgumentException("No dynamic records for storing the name.");
        }
        record.setInUse(true);
        byte[] data = PropertyStore.encodeString((String)name);
        if (data.length > dynamicIds.length * 30) {
            throw new IllegalArgumentException(String.format("[%s] is too long to fit in %d blocks", name, dynamicIds.length));
        }
        if (data.length <= (dynamicIds.length - 1) * 30) {
            throw new IllegalArgumentException(String.format("[%s] is to short to fill %d blocks", name, dynamicIds.length));
        }
        for (int i = 0; i < dynamicIds.length; ++i) {
            byte[] part = new byte[Math.min(30, data.length - i * 30)];
            System.arraycopy(data, i * 30, part, 0, part.length);
            DynamicRecord dynamicRecord = new DynamicRecord((long)dynamicIds[i]);
            dynamicRecord.setInUse(true);
            dynamicRecord.setData(part);
            dynamicRecord.setCreated();
            record.addNameRecord(dynamicRecord);
        }
        record.setNameId(dynamicIds[0]);
        return record;
    }
}

