/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.OwningRecordCheck;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.statistics.DefaultCounts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.test.Property;

public class ExecutionOrderIntegrationTest {
    @Rule
    public final GraphStoreFixture fixture = new GraphStoreFixture(){

        @Override
        protected void generateInitialData(GraphDatabaseService graphDb) {
            try (Transaction tx = graphDb.beginTx();){
                Node node1 = (Node)Property.set((PropertyContainer)graphDb.createNode(), (Property[])new Property[0]);
                Node node2 = (Node)Property.set((PropertyContainer)graphDb.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"value")});
                node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"C"));
                tx.success();
            }
        }
    };

    @Test
    public void shouldRunChecksInSingleThreadedPass() throws Exception {
        StoreAccess store = this.fixture.directStoreAccess().nativeStores();
        int threads = ConsistencyCheckService.defaultConsistencyCheckThreadsNumber();
        DefaultCacheAccess cacheAccess = new DefaultCacheAccess((Counts)new DefaultCounts(threads), threads);
        RecordAccess access = FullCheck.recordAccess((StoreAccess)store, (CacheAccess)cacheAccess);
        FullCheck singlePass = new FullCheck(ExecutionOrderIntegrationTest.config(), ProgressMonitorFactory.NONE, Statistics.NONE, threads);
        ConsistencySummaryStatistics singlePassSummary = new ConsistencySummaryStatistics();
        InconsistencyLogger logger = (InconsistencyLogger)Mockito.mock(InconsistencyLogger.class);
        InvocationLog singlePassChecks = new InvocationLog();
        singlePass.execute(this.fixture.directStoreAccess(), (CheckDecorator)new LogDecorator(singlePassChecks), access, new InconsistencyReport(logger, singlePassSummary), (CacheAccess)cacheAccess, ConsistencyReporter.NO_MONITOR);
        Mockito.verifyZeroInteractions((Object[])new Object[]{logger});
        Assert.assertEquals((String)"Expected no inconsistencies in single pass.", (long)0L, (long)singlePassSummary.getTotalInconsistencyCount());
    }

    static Config config() {
        Map params = MapUtil.stringMap((String[])new String[]{ConsistencyCheckSettings.consistency_check_property_owners.name(), "true"});
        return new Config(params, new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
    }

    private static void assertSameChecks(Map<String, Throwable> singlePassChecks, Map<String, Throwable> multiPassChecks) {
        if (!singlePassChecks.keySet().equals(multiPassChecks.keySet())) {
            HashMap<String, Throwable> missing = new HashMap<String, Throwable>(singlePassChecks);
            HashMap<String, Throwable> extras = new HashMap<String, Throwable>(multiPassChecks);
            missing.keySet().removeAll(multiPassChecks.keySet());
            extras.keySet().removeAll(singlePassChecks.keySet());
            StringBuilder headers = new StringBuilder("\n");
            StringWriter diff = new StringWriter();
            PrintWriter writer = new PrintWriter(diff);
            if (!missing.isEmpty()) {
                writer.append("These expected checks were missing:\n");
                for (Map.Entry check : missing.entrySet()) {
                    writer.append("  ");
                    headers.append("Missing: ").append((String)check.getKey()).append("\n");
                    ((Throwable)check.getValue()).printStackTrace(writer);
                }
            }
            if (!extras.isEmpty()) {
                writer.append("These extra checks were not expected:\n");
                for (Map.Entry check : extras.entrySet()) {
                    writer.append("  ");
                    headers.append("Unexpected: ").append((String)check.getKey()).append("\n");
                    ((Throwable)check.getValue()).printStackTrace(writer);
                }
            }
            Assert.fail((String)(headers.toString() + diff.toString()));
        }
    }

    private static class ComparativeLogging
    implements RecordAccess {
        private final RecordAccess access;
        private final InvocationLog log;

        ComparativeLogging(RecordAccess access, InvocationLog log) {
            this.access = access;
            this.log = log;
        }

        private <T extends AbstractBaseRecord> LoggingReference<T> logging(RecordReference<T> actual) {
            return new LoggingReference<T>(actual, this.log);
        }

        public RecordReference<DynamicRecord> schema(long id) {
            return this.logging(this.access.schema(id));
        }

        public RecordReference<NodeRecord> node(long id) {
            return this.logging(this.access.node(id));
        }

        public RecordReference<RelationshipRecord> relationship(long id) {
            return this.logging(this.access.relationship(id));
        }

        public RecordReference<RelationshipGroupRecord> relationshipGroup(long id) {
            return this.logging(this.access.relationshipGroup(id));
        }

        public RecordReference<PropertyRecord> property(long id) {
            return this.logging(this.access.property(id));
        }

        public RecordReference<RelationshipTypeTokenRecord> relationshipType(int id) {
            return this.logging(this.access.relationshipType(id));
        }

        public RecordReference<PropertyKeyTokenRecord> propertyKey(int id) {
            return this.logging(this.access.propertyKey(id));
        }

        public RecordReference<DynamicRecord> string(long id) {
            return this.logging(this.access.string(id));
        }

        public RecordReference<DynamicRecord> array(long id) {
            return this.logging(this.access.array(id));
        }

        public RecordReference<DynamicRecord> relationshipTypeName(int id) {
            return this.logging(this.access.relationshipTypeName(id));
        }

        public RecordReference<DynamicRecord> nodeLabels(long id) {
            return this.logging(this.access.nodeLabels(id));
        }

        public RecordReference<LabelTokenRecord> label(int id) {
            return this.logging(this.access.label(id));
        }

        public RecordReference<DynamicRecord> labelName(int id) {
            return this.logging(this.access.labelName(id));
        }

        public RecordReference<DynamicRecord> propertyKeyName(int id) {
            return this.logging(this.access.propertyKeyName(id));
        }

        public RecordReference<NeoStoreRecord> graph() {
            return this.logging(this.access.graph());
        }

        public boolean shouldCheck(long id, MultiPassStore store) {
            return this.access.shouldCheck(id, store);
        }

        public CacheAccess cacheAccess() {
            return this.access.cacheAccess();
        }

        public Iterator<PropertyRecord> rawPropertyChain(long firstId) {
            return this.access.rawPropertyChain(firstId);
        }
    }

    private static class ReporterSpy<T extends AbstractBaseRecord>
    implements Answer<Object> {
        private final RecordReference<T> reference;
        private final PendingReferenceCheck<T> reporter;
        private final InvocationLog log;

        public ReporterSpy(RecordReference<T> reference, PendingReferenceCheck<T> reporter, InvocationLog log) {
            this.reference = reference;
            this.reporter = reporter;
            this.log = log;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            if (!(this.reference instanceof RecordReference.SkippingReference)) {
                this.log.log(this.reporter, invocation);
            }
            return invocation.callRealMethod();
        }
    }

    private static class LoggingReference<T extends AbstractBaseRecord>
    implements RecordReference<T> {
        private final RecordReference<T> reference;
        private final InvocationLog log;

        LoggingReference(RecordReference<T> reference, InvocationLog log) {
            this.reference = reference;
            this.log = log;
        }

        public void dispatch(PendingReferenceCheck<T> reporter) {
            this.reference.dispatch((PendingReferenceCheck)Mockito.mock(reporter.getClass(), (MockSettings)Mockito.withSettings().spiedInstance(reporter).defaultAnswer(new ReporterSpy<T>(this.reference, reporter, this.log))));
        }
    }

    private static class LoggingChecker<REC extends AbstractBaseRecord, REP extends ConsistencyReport>
    implements OwningRecordCheck<REC, REP> {
        private final RecordCheck<REC, REP> checker;
        private final InvocationLog log;

        LoggingChecker(RecordCheck<REC, REP> checker, InvocationLog log) {
            this.checker = checker;
            this.log = log;
        }

        public void check(REC record, CheckerEngine<REC, REP> engine, RecordAccess records) {
            this.checker.check(record, engine, (RecordAccess)new ComparativeLogging(records, this.log));
        }

        public ComparativeRecordChecker<REC, PrimitiveRecord, REP> ownerCheck() {
            if (this.checker instanceof OwningRecordCheck) {
                return ((OwningRecordCheck)this.checker).ownerCheck();
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class LogDecorator
    implements CheckDecorator {
        private final InvocationLog log;

        LogDecorator(InvocationLog log) {
            this.log = log;
        }

        public void prepare() {
        }

        <REC extends AbstractBaseRecord, REP extends ConsistencyReport> OwningRecordCheck<REC, REP> logging(RecordCheck<REC, REP> checker) {
            return new LoggingChecker<REC, REP>(checker, this.log);
        }

        public OwningRecordCheck<NeoStoreRecord, ConsistencyReport.NeoStoreConsistencyReport> decorateNeoStoreChecker(OwningRecordCheck<NeoStoreRecord, ConsistencyReport.NeoStoreConsistencyReport> checker) {
            return this.logging((RecordCheck)checker);
        }

        public OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> decorateNodeChecker(OwningRecordCheck<NodeRecord, ConsistencyReport.NodeConsistencyReport> checker) {
            return this.logging((RecordCheck)checker);
        }

        public OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> decorateRelationshipChecker(OwningRecordCheck<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport> checker) {
            return this.logging((RecordCheck)checker);
        }

        public RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> decoratePropertyChecker(RecordCheck<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> checker) {
            return this.logging(checker);
        }

        public RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> decoratePropertyKeyTokenChecker(RecordCheck<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> checker) {
            return this.logging(checker);
        }

        public RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> decorateRelationshipTypeTokenChecker(RecordCheck<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> checker) {
            return this.logging(checker);
        }

        public RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> decorateLabelTokenChecker(RecordCheck<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> checker) {
            return this.logging(checker);
        }

        public RecordCheck<NodeRecord, ConsistencyReport.LabelsMatchReport> decorateLabelMatchChecker(RecordCheck<NodeRecord, ConsistencyReport.LabelsMatchReport> checker) {
            return this.logging(checker);
        }

        public RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> decorateRelationshipGroupChecker(RecordCheck<RelationshipGroupRecord, ConsistencyReport.RelationshipGroupConsistencyReport> checker) {
            return this.logging(checker);
        }
    }

    private static class InvocationLog {
        private final Map<String, Throwable> data = new HashMap<String, Throwable>();
        private final Map<String, Integer> duplicates = new HashMap<String, Integer>();

        private InvocationLog() {
        }

        void log(PendingReferenceCheck<?> check, InvocationOnMock invocation) {
            Method method = invocation.getMethod();
            if (Object.class == method.getDeclaringClass() && "finalize".equals(method.getName())) {
                return;
            }
            StringBuilder entry = new StringBuilder(method.getName()).append('(');
            entry.append(check);
            for (Object arg : invocation.getArguments()) {
                if (!(arg instanceof AbstractBaseRecord)) continue;
                AbstractBaseRecord record = (AbstractBaseRecord)arg;
                entry.append(',').append(record.getClass().getSimpleName()).append('[').append(record.getLongId()).append(']');
            }
            String message = entry.append(')').toString();
            if (null != this.data.put(message, new Throwable(message))) {
                Integer cur = this.duplicates.get(message);
                if (cur == null) {
                    cur = 1;
                }
                this.duplicates.put(message, cur + 1);
            }
        }
    }
}

