/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.function.Predicate;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class StoreProcessorTest {
    @Test
    public void shouldProcessAllTheRecordsInAStore() throws Exception {
        StoreProcessor processor = new StoreProcessor(CheckDecorator.NONE, (ConsistencyReport.Reporter)Mockito.mock(ConsistencyReport.Reporter.class), Stage.SEQUENTIAL_FORWARD, CacheAccess.EMPTY);
        RecordStore recordStore = (RecordStore)Mockito.mock(RecordStore.class);
        Mockito.when((Object)recordStore.getHighId()).thenReturn((Object)3L);
        Mockito.when((Object)recordStore.forceGetRecord(((Long)Matchers.any(Long.class)).longValue())).thenReturn((Object)new NodeRecord(0L, false, 0L, 0L));
        processor.applyFiltered(recordStore, new Predicate[0]);
        ((RecordStore)Mockito.verify((Object)recordStore)).forceGetRecord(0L);
        ((RecordStore)Mockito.verify((Object)recordStore)).forceGetRecord(1L);
        ((RecordStore)Mockito.verify((Object)recordStore)).forceGetRecord(2L);
        ((RecordStore)Mockito.verify((Object)recordStore, (VerificationMode)Mockito.never())).forceGetRecord(3L);
    }

    @Test
    public void shouldStopProcessingRecordsWhenSignalledToStop() throws Exception {
        final StoreProcessor processor = new StoreProcessor(CheckDecorator.NONE, (ConsistencyReport.Reporter)Mockito.mock(ConsistencyReport.Reporter.class), Stage.SEQUENTIAL_FORWARD, CacheAccess.EMPTY);
        RecordStore recordStore = (RecordStore)Mockito.mock(RecordStore.class);
        Mockito.when((Object)recordStore.getHighId()).thenReturn((Object)4L);
        Mockito.when((Object)recordStore.forceGetRecord(0L)).thenReturn((Object)new NodeRecord(0L, false, 0L, 0L));
        Mockito.when((Object)recordStore.forceGetRecord(1L)).thenReturn((Object)new NodeRecord(0L, false, 0L, 0L));
        Mockito.when((Object)recordStore.forceGetRecord(2L)).thenAnswer((Answer)new Answer<NodeRecord>(){

            public NodeRecord answer(InvocationOnMock invocation) throws Throwable {
                processor.stop();
                return new NodeRecord(2L, true, false, 0L, 0L, 0L);
            }
        });
        processor.applyFiltered(recordStore, new Predicate[0]);
        ((RecordStore)Mockito.verify((Object)recordStore)).forceGetRecord(0L);
        ((RecordStore)Mockito.verify((Object)recordStore)).forceGetRecord(1L);
        ((RecordStore)Mockito.verify((Object)recordStore)).forceGetRecord(2L);
        ((RecordStore)Mockito.verify((Object)recordStore, (VerificationMode)Mockito.never())).forceGetRecord(3L);
    }
}

