/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.repair.OwningNodeRelationshipChain;
import org.neo4j.consistency.repair.RecordSet;
import org.neo4j.consistency.repair.RelationshipChainExplorer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.Abstract64BitRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class OwningNodeRelationshipChainTest {
    @Test
    public void shouldFindBothChainsThatTheRelationshipRecordShouldBelongTo() throws Exception {
        int node1 = 101;
        int node1Rel = 1001;
        int node2 = 201;
        int node2Rel = 2001;
        int sharedRel = 1000;
        int relType = 0;
        RecordSet node1RelChain = RecordSet.asSet((Abstract64BitRecord[])new RelationshipRecord[]{new RelationshipRecord((long)node1Rel, (long)node1, (long)(node1 - 1), relType), new RelationshipRecord((long)sharedRel, (long)node1, (long)node2, relType), new RelationshipRecord((long)(node1Rel + 1), (long)(node1 + 1), (long)node1, relType)});
        RecordSet node2RelChain = RecordSet.asSet((Abstract64BitRecord[])new RelationshipRecord[]{new RelationshipRecord((long)node2Rel, (long)(node2 - 1), (long)node2, relType), new RelationshipRecord((long)sharedRel, (long)node1, (long)node2, relType), new RelationshipRecord((long)(node2Rel + 1), (long)node2, (long)(node2 + 1), relType)});
        RecordStore recordStore = (RecordStore)Mockito.mock(RecordStore.class);
        Mockito.when((Object)recordStore.forceGetRecord((long)node1)).thenReturn((Object)new NodeRecord((long)node1, false, (long)node1Rel, (long)Record.NO_NEXT_PROPERTY.intValue()));
        Mockito.when((Object)recordStore.forceGetRecord((long)node2)).thenReturn((Object)new NodeRecord((long)node2, false, (long)node2Rel, (long)Record.NO_NEXT_PROPERTY.intValue()));
        RelationshipChainExplorer relationshipChainExplorer = (RelationshipChainExplorer)Mockito.mock(RelationshipChainExplorer.class);
        Mockito.when((Object)relationshipChainExplorer.followChainFromNode((long)node1, (long)node1Rel)).thenReturn((Object)node1RelChain);
        Mockito.when((Object)relationshipChainExplorer.followChainFromNode((long)node2, (long)node2Rel)).thenReturn((Object)node2RelChain);
        OwningNodeRelationshipChain owningChainFinder = new OwningNodeRelationshipChain(relationshipChainExplorer, recordStore);
        RecordSet recordsInChains = owningChainFinder.findRelationshipChainsThatThisRecordShouldBelongTo(new RelationshipRecord((long)sharedRel, (long)node1, (long)node2, relType));
        Assert.assertThat((Object)recordsInChains, this.containsAllRecords((RecordSet<RelationshipRecord>)node1RelChain));
        Assert.assertThat((Object)recordsInChains, this.containsAllRecords((RecordSet<RelationshipRecord>)node2RelChain));
    }

    private Matcher<RecordSet<RelationshipRecord>> containsAllRecords(final RecordSet<RelationshipRecord> expectedSet) {
        return new TypeSafeMatcher<RecordSet<RelationshipRecord>>(){

            public boolean matchesSafely(RecordSet<RelationshipRecord> actualSet) {
                return actualSet.containsAll(expectedSet);
            }

            public void describeTo(Description description) {
                description.appendText("RecordSet containing ").appendValueList("[", ",", "]", (Iterable)expectedSet);
            }
        };
    }
}

