/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.repair.RecordSet;
import org.neo4j.consistency.repair.RelationshipChainExplorer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class RelationshipChainExplorerTest {
    private static final int NDegreeTwoNodes = 10;
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public TargetDirectory.TestDirectory storeLocation = TargetDirectory.testDirForTest(this.getClass());
    private StoreAccess store;

    @Before
    public void setupStoreAccess() {
        this.store = this.createStoreWithOneHighDegreeNodeAndSeveralDegreeTwoNodes(10);
    }

    @After
    public void tearDownStoreAccess() {
        this.store.close();
    }

    @Test
    public void shouldLoadAllConnectedRelationshipRecordsAndTheirFullChainsOfRelationshipRecords() throws Exception {
        RecordStore relationshipStore = this.store.getRelationshipStore();
        int relationshipIdInMiddleOfChain = 10;
        RecordSet records = new RelationshipChainExplorer(relationshipStore).exploreRelationshipRecordChainsToDepthTwo((RelationshipRecord)relationshipStore.getRecord((long)relationshipIdInMiddleOfChain));
        Assert.assertEquals((long)20L, (long)records.size());
    }

    @Test
    public void shouldCopeWithAChainThatReferencesNotInUseZeroValueRecords() throws Exception {
        RecordStore relationshipStore = this.store.getRelationshipStore();
        this.breakTheChain((RecordStore<RelationshipRecord>)relationshipStore);
        int relationshipIdInMiddleOfChain = 10;
        RecordSet records = new RelationshipChainExplorer(relationshipStore).exploreRelationshipRecordChainsToDepthTwo((RelationshipRecord)relationshipStore.getRecord((long)relationshipIdInMiddleOfChain));
        int recordsInaccessibleBecauseOfBrokenChain = 3;
        Assert.assertEquals((long)(20 - recordsInaccessibleBecauseOfBrokenChain), (long)records.size());
    }

    private void breakTheChain(RecordStore<RelationshipRecord> relationshipStore) {
        int relationshipTowardsEndOfChain = 16;
        relationshipStore.updateRecord((AbstractBaseRecord)new RelationshipRecord((long)relationshipTowardsEndOfChain, 0L, 0L, 0));
    }

    private StoreAccess createStoreWithOneHighDegreeNodeAndSeveralDegreeTwoNodes(int nDegreeTwoNodes) {
        File storeDirectory = this.storeLocation.graphDbDir();
        GraphDatabaseService database = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDirectory);
        try (Transaction transaction = database.beginTx();){
            Node denseNode = database.createNode();
            for (int i = 0; i < nDegreeTwoNodes; ++i) {
                Node degreeTwoNode = database.createNode();
                Node leafNode = database.createNode();
                if (i % 2 == 0) {
                    denseNode.createRelationshipTo(degreeTwoNode, (RelationshipType)TestRelationshipType.CONNECTED);
                } else {
                    degreeTwoNode.createRelationshipTo(denseNode, (RelationshipType)TestRelationshipType.CONNECTED);
                }
                degreeTwoNode.createRelationshipTo(leafNode, (RelationshipType)TestRelationshipType.CONNECTED);
            }
            transaction.success();
        }
        database.shutdown();
        PageCache pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)new DefaultFileSystemAbstraction());
        return new StoreAccess(pageCache, storeDirectory).initialize();
    }

    static enum TestRelationshipType implements RelationshipType
    {
        CONNECTED;

    }
}

