/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.ComparativeRecordChecker;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.report.PendingReferenceCheck;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;

public class PendingReferenceCheckTest {
    private final PendingReferenceCheck<PropertyRecord> referenceCheck;

    public PendingReferenceCheckTest() {
        RecordAccess records = (RecordAccess)Mockito.mock(RecordAccess.class);
        ConsistencyReporter.ReportHandler handler = new ConsistencyReporter.ReportHandler((InconsistencyReport)Mockito.mock(InconsistencyReport.class), (ConsistencyReporter.ProxyFactory)Mockito.mock(ConsistencyReporter.ProxyFactory.class), RecordType.PROPERTY, records, (AbstractBaseRecord)new PropertyRecord(0L), ConsistencyReporter.NO_MONITOR);
        this.referenceCheck = new PendingReferenceCheck((CheckerEngine)handler, (ComparativeRecordChecker)Mockito.mock(ComparativeRecordChecker.class));
    }

    @Test
    public void shouldAllowSkipAfterSkip() throws Exception {
        this.referenceCheck.skip();
        this.referenceCheck.skip();
    }

    @Test
    public void shouldAllowSkipAfterCheckReference() throws Exception {
        this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null);
        this.referenceCheck.skip();
    }

    @Test
    public void shouldAllowSkipAfterCheckDiffReference() throws Exception {
        this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null);
        this.referenceCheck.skip();
    }

    @Test
    public void shouldNotAllowCheckReferenceAfterSkip() throws Exception {
        this.referenceCheck.skip();
        try {
            this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"Reference has already been checked.", (Object)expected.getMessage());
        }
    }

    @Test
    public void shouldNotAllowCheckDiffReferenceAfterSkip() throws Exception {
        this.referenceCheck.skip();
        try {
            this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"Reference has already been checked.", (Object)expected.getMessage());
        }
    }

    @Test
    public void shouldNotAllowCheckReferenceAfterCheckReference() throws Exception {
        this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null);
        try {
            this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"Reference has already been checked.", (Object)expected.getMessage());
        }
    }

    @Test
    public void shouldNotAllowCheckDiffReferenceAfterCheckReference() throws Exception {
        this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null);
        try {
            this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"Reference has already been checked.", (Object)expected.getMessage());
        }
    }

    @Test
    public void shouldNotAllowCheckReferenceAfterCheckDiffReference() throws Exception {
        this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null);
        try {
            this.referenceCheck.checkReference((AbstractBaseRecord)new PropertyRecord(0L), null);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"Reference has already been checked.", (Object)expected.getMessage());
        }
    }

    @Test
    public void shouldNotAllowCheckDiffReferenceAfterCheckDiffReference() throws Exception {
        this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null);
        try {
            this.referenceCheck.checkDiffReference((AbstractBaseRecord)new PropertyRecord(0L), (AbstractBaseRecord)new PropertyRecord(0L), null);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException expected) {
            Assert.assertEquals((Object)"Reference has already been checked.", (Object)expected.getMessage());
        }
    }
}

