/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store.paging;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.consistency.store.paging.CachedPageList;
import org.neo4j.consistency.store.paging.Page;

public class CachedPageListTest {
    @Test
    public void insertPagesByMovingThemFromNullListToTailOfARealList() throws Exception {
        CachedPageList list = new CachedPageList();
        BasicPage page1 = new BasicPage();
        BasicPage page2 = new BasicPage();
        BasicPage page3 = new BasicPage();
        BasicPage page4 = new BasicPage();
        BasicPage page5 = new BasicPage();
        page1.moveToTailOf(list);
        page2.moveToTailOf(list);
        page3.moveToTailOf(list);
        page4.moveToTailOf(list);
        page5.moveToTailOf(list);
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertSame((Object)((Object)page1), (Object)list.head);
        Assert.assertSame((Object)((Object)page5), (Object)list.tail);
        Assert.assertSame((Object)list, (Object)page1.currentList);
        Assert.assertSame((Object)list, (Object)page2.currentList);
        Assert.assertSame((Object)list, (Object)page3.currentList);
        Assert.assertSame((Object)list, (Object)page4.currentList);
        Assert.assertSame((Object)list, (Object)page5.currentList);
        Assert.assertNull((Object)page1.prevPage);
        Assert.assertSame((Object)((Object)page1), (Object)page2.prevPage);
        Assert.assertSame((Object)((Object)page2), (Object)page3.prevPage);
        Assert.assertSame((Object)((Object)page3), (Object)page4.prevPage);
        Assert.assertSame((Object)((Object)page4), (Object)page5.prevPage);
        Assert.assertSame((Object)((Object)page2), (Object)page1.nextPage);
        Assert.assertSame((Object)((Object)page3), (Object)page2.nextPage);
        Assert.assertSame((Object)((Object)page4), (Object)page3.nextPage);
        Assert.assertSame((Object)((Object)page5), (Object)page4.nextPage);
        Assert.assertNull((Object)page5.nextPage);
    }

    @Test
    public void moveSingletonToEmptyList() throws Exception {
        CachedPageList list1 = new CachedPageList();
        CachedPageList list2 = new CachedPageList();
        BasicPage page = new BasicPage();
        page.moveToTailOf(list1);
        page.moveToTailOf(list2);
        Assert.assertEquals((long)0L, (long)list1.size());
        Assert.assertNull((Object)list1.head);
        Assert.assertNull((Object)list1.tail);
        Assert.assertEquals((long)1L, (long)list2.size());
        Assert.assertSame((Object)((Object)page), (Object)list2.head);
        Assert.assertSame((Object)((Object)page), (Object)list2.tail);
        Assert.assertSame((Object)list2, (Object)page.currentList);
        Assert.assertNull((Object)page.prevPage);
        Assert.assertNull((Object)page.nextPage);
    }

    @Test
    public void moveHeadOfTwoPageListToEmptyList() throws Exception {
        CachedPageList list1 = new CachedPageList();
        CachedPageList list2 = new CachedPageList();
        BasicPage page1 = new BasicPage();
        BasicPage page2 = new BasicPage();
        page1.moveToTailOf(list1);
        page2.moveToTailOf(list1);
        page1.moveToTailOf(list2);
        Assert.assertEquals((long)1L, (long)list1.size());
        Assert.assertSame((Object)((Object)page2), (Object)list1.head);
        Assert.assertSame((Object)((Object)page2), (Object)list1.tail);
        Assert.assertSame((Object)list1, (Object)page2.currentList);
        Assert.assertNull((Object)page2.prevPage);
        Assert.assertNull((Object)page2.nextPage);
        Assert.assertEquals((long)1L, (long)list2.size());
        Assert.assertSame((Object)((Object)page1), (Object)list2.head);
        Assert.assertSame((Object)((Object)page1), (Object)list2.tail);
        Assert.assertSame((Object)list2, (Object)page1.currentList);
        Assert.assertNull((Object)page1.prevPage);
        Assert.assertNull((Object)page1.nextPage);
    }

    @Test
    public void moveTailOfTwoPageListToEmptyList() throws Exception {
        CachedPageList list1 = new CachedPageList();
        CachedPageList list2 = new CachedPageList();
        BasicPage page1 = new BasicPage();
        BasicPage page2 = new BasicPage();
        page1.moveToTailOf(list1);
        page2.moveToTailOf(list1);
        page2.moveToTailOf(list2);
        Assert.assertEquals((long)1L, (long)list1.size());
        Assert.assertSame((Object)((Object)page1), (Object)list1.head);
        Assert.assertSame((Object)((Object)page1), (Object)list1.tail);
        Assert.assertSame((Object)list1, (Object)page1.currentList);
        Assert.assertNull((Object)page1.prevPage);
        Assert.assertNull((Object)page1.nextPage);
        Assert.assertEquals((long)1L, (long)list2.size());
        Assert.assertSame((Object)((Object)page2), (Object)list2.head);
        Assert.assertSame((Object)((Object)page2), (Object)list2.tail);
        Assert.assertSame((Object)list2, (Object)page2.currentList);
        Assert.assertNull((Object)page2.prevPage);
        Assert.assertNull((Object)page2.nextPage);
    }

    @Test
    public void moveMiddleOfThreePageListToEmptyList() throws Exception {
        CachedPageList list1 = new CachedPageList();
        CachedPageList list2 = new CachedPageList();
        BasicPage page1 = new BasicPage();
        BasicPage page2 = new BasicPage();
        BasicPage page3 = new BasicPage();
        page1.moveToTailOf(list1);
        page2.moveToTailOf(list1);
        page3.moveToTailOf(list1);
        page2.moveToTailOf(list2);
        Assert.assertEquals((long)2L, (long)list1.size());
        Assert.assertSame((Object)((Object)page1), (Object)list1.head);
        Assert.assertSame((Object)((Object)page3), (Object)list1.tail);
        Assert.assertSame((Object)list1, (Object)page1.currentList);
        Assert.assertSame((Object)list1, (Object)page3.currentList);
        Assert.assertNull((Object)page1.prevPage);
        Assert.assertSame((Object)((Object)page1), (Object)page3.prevPage);
        Assert.assertSame((Object)((Object)page3), (Object)page1.nextPage);
        Assert.assertNull((Object)page3.nextPage);
        Assert.assertEquals((long)1L, (long)list2.size());
        Assert.assertSame((Object)((Object)page2), (Object)list2.head);
        Assert.assertSame((Object)((Object)page2), (Object)list2.tail);
        Assert.assertSame((Object)list2, (Object)page2.currentList);
        Assert.assertNull((Object)page2.prevPage);
        Assert.assertNull((Object)page2.nextPage);
    }

    @Test
    public void moveMiddleOfLongListToEmptyList() throws Exception {
        CachedPageList list1 = new CachedPageList();
        CachedPageList list2 = new CachedPageList();
        BasicPage page1 = new BasicPage();
        BasicPage page2 = new BasicPage();
        BasicPage page3 = new BasicPage();
        BasicPage page4 = new BasicPage();
        BasicPage page5 = new BasicPage();
        page1.moveToTailOf(list1);
        page2.moveToTailOf(list1);
        page3.moveToTailOf(list1);
        page4.moveToTailOf(list1);
        page5.moveToTailOf(list1);
        page3.moveToTailOf(list2);
        Assert.assertEquals((long)4L, (long)list1.size());
        Assert.assertSame((Object)((Object)page1), (Object)list1.head);
        Assert.assertSame((Object)((Object)page5), (Object)list1.tail);
        Assert.assertSame((Object)list1, (Object)page1.currentList);
        Assert.assertSame((Object)list1, (Object)page2.currentList);
        Assert.assertSame((Object)list1, (Object)page4.currentList);
        Assert.assertSame((Object)list1, (Object)page5.currentList);
        Assert.assertNull((Object)page1.prevPage);
        Assert.assertSame((Object)((Object)page1), (Object)page2.prevPage);
        Assert.assertSame((Object)((Object)page2), (Object)page4.prevPage);
        Assert.assertSame((Object)((Object)page4), (Object)page5.prevPage);
        Assert.assertSame((Object)((Object)page2), (Object)page1.nextPage);
        Assert.assertSame((Object)((Object)page4), (Object)page2.nextPage);
        Assert.assertSame((Object)((Object)page5), (Object)page4.nextPage);
        Assert.assertNull((Object)page5.nextPage);
        Assert.assertEquals((long)1L, (long)list2.size());
        Assert.assertSame((Object)((Object)page3), (Object)list2.head);
        Assert.assertSame((Object)((Object)page3), (Object)list2.tail);
        Assert.assertSame((Object)list2, (Object)page3.currentList);
        Assert.assertNull((Object)page3.prevPage);
        Assert.assertNull((Object)page3.nextPage);
    }

    @Test
    public void moveMiddleOfLongListToNonEmptyList() throws Exception {
        CachedPageList list1 = new CachedPageList();
        CachedPageList list2 = new CachedPageList();
        BasicPage page1 = new BasicPage();
        BasicPage page2 = new BasicPage();
        BasicPage page3 = new BasicPage();
        BasicPage page4 = new BasicPage();
        BasicPage page5 = new BasicPage();
        page1.moveToTailOf(list1);
        page2.moveToTailOf(list1);
        page3.moveToTailOf(list1);
        page4.moveToTailOf(list1);
        page5.moveToTailOf(list1);
        BasicPage page6 = new BasicPage();
        BasicPage page7 = new BasicPage();
        page6.moveToTailOf(list2);
        page7.moveToTailOf(list2);
        page3.moveToTailOf(list2);
        Assert.assertEquals((long)4L, (long)list1.size());
        Assert.assertSame((Object)((Object)page1), (Object)list1.head);
        Assert.assertSame((Object)((Object)page5), (Object)list1.tail);
        Assert.assertSame((Object)list1, (Object)page1.currentList);
        Assert.assertSame((Object)list1, (Object)page2.currentList);
        Assert.assertSame((Object)list1, (Object)page4.currentList);
        Assert.assertSame((Object)list1, (Object)page5.currentList);
        Assert.assertNull((Object)page1.prevPage);
        Assert.assertSame((Object)((Object)page1), (Object)page2.prevPage);
        Assert.assertSame((Object)((Object)page2), (Object)page4.prevPage);
        Assert.assertSame((Object)((Object)page4), (Object)page5.prevPage);
        Assert.assertSame((Object)((Object)page2), (Object)page1.nextPage);
        Assert.assertSame((Object)((Object)page4), (Object)page2.nextPage);
        Assert.assertSame((Object)((Object)page5), (Object)page4.nextPage);
        Assert.assertNull((Object)page5.nextPage);
        Assert.assertEquals((long)3L, (long)list2.size());
        Assert.assertSame((Object)((Object)page6), (Object)list2.head);
        Assert.assertSame((Object)((Object)page3), (Object)list2.tail);
        Assert.assertSame((Object)list2, (Object)page6.currentList);
        Assert.assertSame((Object)list2, (Object)page7.currentList);
        Assert.assertSame((Object)list2, (Object)page3.currentList);
        Assert.assertNull((Object)page6.prevPage);
        Assert.assertSame((Object)((Object)page6), (Object)page7.prevPage);
        Assert.assertSame((Object)((Object)page7), (Object)page3.prevPage);
        Assert.assertSame((Object)((Object)page7), (Object)page6.nextPage);
        Assert.assertSame((Object)((Object)page3), (Object)page7.nextPage);
        Assert.assertNull((Object)page3.nextPage);
    }

    @Test
    public void shouldRemoveHeadOfSingletonList() throws Exception {
        CachedPageList list = new CachedPageList();
        BasicPage page = new BasicPage();
        page.moveToTailOf(list);
        Page removedPage = list.removeHead();
        Assert.assertSame((Object)((Object)page), (Object)removedPage);
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertNull((Object)list.head);
        Assert.assertNull((Object)list.tail);
        Assert.assertNull((Object)page.currentList);
        Assert.assertNull((Object)page.prevPage);
        Assert.assertNull((Object)page.nextPage);
    }

    @Test
    public void shouldRemoveHeadOfTwoPageList() throws Exception {
        CachedPageList list = new CachedPageList();
        BasicPage page1 = new BasicPage();
        BasicPage page2 = new BasicPage();
        page1.moveToTailOf(list);
        page2.moveToTailOf(list);
        Page removedPage = list.removeHead();
        Assert.assertSame((Object)((Object)page1), (Object)removedPage);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertSame((Object)((Object)page2), (Object)list.head);
        Assert.assertSame((Object)((Object)page2), (Object)list.tail);
        Assert.assertNull((Object)page1.currentList);
        Assert.assertNull((Object)page1.prevPage);
        Assert.assertNull((Object)page1.nextPage);
        Assert.assertSame((Object)list, (Object)page2.currentList);
        Assert.assertNull((Object)page2.prevPage);
        Assert.assertNull((Object)page2.nextPage);
    }

    @Test
    public void shouldRemoveHeadOfLongList() throws Exception {
        CachedPageList list = new CachedPageList();
        BasicPage page1 = new BasicPage();
        BasicPage page2 = new BasicPage();
        BasicPage page3 = new BasicPage();
        page1.moveToTailOf(list);
        page2.moveToTailOf(list);
        page3.moveToTailOf(list);
        Page removedPage = list.removeHead();
        Assert.assertSame((Object)((Object)page1), (Object)removedPage);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertSame((Object)((Object)page2), (Object)list.head);
        Assert.assertSame((Object)((Object)page3), (Object)list.tail);
        Assert.assertNull((Object)page1.currentList);
        Assert.assertNull((Object)page1.prevPage);
        Assert.assertNull((Object)page1.nextPage);
        Assert.assertSame((Object)list, (Object)page2.currentList);
        Assert.assertSame((Object)list, (Object)page3.currentList);
        Assert.assertNull((Object)page2.prevPage);
        Assert.assertSame((Object)((Object)page2), (Object)page3.prevPage);
        Assert.assertSame((Object)((Object)page3), (Object)page2.nextPage);
        Assert.assertNull((Object)page3.nextPage);
    }

    static class BasicPage
    extends Page<Integer> {
        BasicPage() {
        }

        protected void evict(Integer payload) {
        }

        protected void hit() {
        }
    }
}

