/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.Property;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class ConsistencyCheckServiceIntegrationTest {
    @Rule
    public final GraphStoreFixture fixture = new GraphStoreFixture(){

        @Override
        protected void generateInitialData(GraphDatabaseService graphDb) {
            try (Transaction tx = graphDb.beginTx();){
                Node node1 = (Node)Property.set((PropertyContainer)graphDb.createNode(), (Property[])new Property[0]);
                Node node2 = (Node)Property.set((PropertyContainer)graphDb.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"value")});
                node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"C"));
                tx.success();
            }
        }
    };
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldSucceedIfStoreIsConsistent() throws Exception {
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Config configuration = new Config(this.settings(new String[0]), new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertEquals((Object)ConsistencyCheckService.Result.SUCCESS, (Object)result);
        File reportFile = new File(this.fixture.directory(), ConsistencyCheckService.defaultLogFileName((Date)timestamp));
        Assert.assertFalse((String)("Unexpected generation of consistency check report file: " + reportFile), (boolean)reportFile.exists());
    }

    @Test
    public void shouldFailIfTheStoreInNotConsistent() throws Exception {
        this.breakNodeStore();
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Config configuration = new Config(this.settings(new String[0]), new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertEquals((Object)ConsistencyCheckService.Result.FAILURE, (Object)result);
        File reportFile = new File(this.fixture.directory(), ConsistencyCheckService.defaultLogFileName((Date)timestamp));
        Assert.assertTrue((String)("Inconsistency report file " + reportFile + " not generated"), (boolean)reportFile.exists());
    }

    @Test
    public void shouldWriteInconsistenciesToLogFileAtSpecifiedLocation() throws Exception {
        this.breakNodeStore();
        ConsistencyCheckService service = new ConsistencyCheckService();
        File specificLogFile = new File(this.testDirectory.directory(), "specific_logfile.txt");
        Config configuration = new Config(this.settings(ConsistencyCheckSettings.consistency_check_report_file.name(), specificLogFile.getPath()), new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
        this.runFullConsistencyCheck(service, configuration);
        Assert.assertTrue((String)("Inconsistency report file " + specificLogFile + " not generated"), (boolean)specificLogFile.exists());
    }

    @Test
    public void shouldNotReportDuplicateForHugeLongValues() throws Exception {
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = new Config(this.settings(new String[0]), new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.graphDbDir());
        String propertyKey = "itemId";
        Label label = DynamicLabel.label((String)"Item");
        try (Transaction tx = db.beginTx();){
            db.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.success();
        }
        tx = db.beginTx();
        var7_7 = null;
        try {
            Property.set((PropertyContainer)db.createNode(new Label[]{label}), (Property[])new Property[]{Property.property((String)propertyKey, (Object)973305894188596880L)});
            Property.set((PropertyContainer)db.createNode(new Label[]{label}), (Property[])new Property[]{Property.property((String)propertyKey, (Object)973305894188596864L)});
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var7_7.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertEquals((Object)ConsistencyCheckService.Result.SUCCESS, (Object)result);
    }

    @Test
    public void shouldAllowGraphCheckDisabled() throws IOException, ConsistencyCheckIncompleteException {
        GraphDatabaseService gds = new GraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.absolutePath());
        try (Transaction tx = gds.beginTx();){
            gds.createNode();
            tx.success();
        }
        gds.shutdown();
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = new Config(this.settings(new String[0]), new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
        configuration.applyChanges(MapUtil.stringMap((String[])new String[]{ConsistencyCheckSettings.consistency_check_graph.name(), "false"}));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertEquals((Object)ConsistencyCheckService.Result.SUCCESS, (Object)result);
    }

    protected Map<String, String> settings(String ... strings) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        return MapUtil.stringMap(defaults, (String[])strings);
    }

    private void breakNodeStore() throws TransactionFailureException {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node(), false, next.relationship(), -1L));
            }
        });
    }

    private ConsistencyCheckService.Result runFullConsistencyCheck(ConsistencyCheckService service, Config configuration) throws ConsistencyCheckIncompleteException, IOException {
        return service.runFullConsistencyCheck(this.fixture.directory(), configuration, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
    }
}

