/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Suite;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.DynamicRecordCheck;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={StringDynamicRecordCheckTest.class, ArrayDynamicRecordCheckTest.class, SchemaDynamicRecordCheckTest.class})
public abstract class DynamicRecordCheckTest
extends RecordCheckTestBase<DynamicRecord, ConsistencyReport.DynamicConsistencyReport, DynamicRecordCheck> {
    private final int blockSize;

    private DynamicRecordCheckTest(DynamicRecordCheck check, int blockSize) {
        super(check, ConsistencyReport.DynamicConsistencyReport.class, new int[0], new MultiPassStore[0]);
        this.blockSize = blockSize;
    }

    @Test
    public void shouldNotReportAnythingForRecordNotInUse() throws Exception {
        DynamicRecord property = DynamicRecordCheckTest.notInUse(this.record(42L));
        ConsistencyReport.DynamicConsistencyReport report = (ConsistencyReport.DynamicConsistencyReport)this.check(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldNotReportAnythingForRecordThatDoesNotReferenceOtherRecords() throws Exception {
        DynamicRecord property = DynamicRecordCheckTest.inUse(this.fill(this.record(42L), this.blockSize / 2));
        ConsistencyReport.DynamicConsistencyReport report = (ConsistencyReport.DynamicConsistencyReport)this.check(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldNotReportAnythingForRecordWithConsistentReferences() throws Exception {
        DynamicRecord property = DynamicRecordCheckTest.inUse(this.fill(this.record(42L)));
        DynamicRecord next = this.add(DynamicRecordCheckTest.inUse(this.fill(this.record(7L), this.blockSize / 2)));
        property.setNextBlock(next.getId());
        ConsistencyReport.DynamicConsistencyReport report = (ConsistencyReport.DynamicConsistencyReport)this.check(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportNextRecordNotInUse() throws Exception {
        DynamicRecord property = DynamicRecordCheckTest.inUse(this.fill(this.record(42L)));
        DynamicRecord next = this.add(DynamicRecordCheckTest.notInUse(this.record(7L)));
        property.setNextBlock(next.getId());
        ConsistencyReport.DynamicConsistencyReport report = (ConsistencyReport.DynamicConsistencyReport)this.check(property);
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report)).nextNotInUse(next);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSelfReferentialNext() throws Exception {
        DynamicRecord property = this.add(DynamicRecordCheckTest.inUse(this.fill(this.record(42L))));
        property.setNextBlock(property.getId());
        ConsistencyReport.DynamicConsistencyReport report = (ConsistencyReport.DynamicConsistencyReport)this.check(property);
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report)).selfReferentialNext();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportNonFullRecordWithNextReference() throws Exception {
        DynamicRecord property = DynamicRecordCheckTest.inUse(this.fill(this.record(42L), this.blockSize - 1));
        DynamicRecord next = this.add(DynamicRecordCheckTest.inUse(this.fill(this.record(7L), this.blockSize / 2)));
        property.setNextBlock(next.getId());
        ConsistencyReport.DynamicConsistencyReport report = (ConsistencyReport.DynamicConsistencyReport)this.check(property);
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report)).recordNotFullReferencesNext();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportInvalidDataLength() throws Exception {
        DynamicRecord property = DynamicRecordCheckTest.inUse(this.record(42L));
        property.setLength(-1);
        ConsistencyReport.DynamicConsistencyReport report = (ConsistencyReport.DynamicConsistencyReport)this.check(property);
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report)).invalidLength();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportEmptyRecord() throws Exception {
        DynamicRecord property = DynamicRecordCheckTest.inUse(this.record(42L));
        ConsistencyReport.DynamicConsistencyReport report = (ConsistencyReport.DynamicConsistencyReport)this.check(property);
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report)).emptyBlock();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportRecordWithEmptyNext() throws Exception {
        DynamicRecord property = DynamicRecordCheckTest.inUse(this.fill(this.record(42L)));
        DynamicRecord next = this.add(DynamicRecordCheckTest.inUse(this.record(7L)));
        property.setNextBlock(next.getId());
        ConsistencyReport.DynamicConsistencyReport report = (ConsistencyReport.DynamicConsistencyReport)this.check(property);
        ((ConsistencyReport.DynamicConsistencyReport)Mockito.verify((Object)report)).emptyNextBlock(next);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    DynamicRecord fill(DynamicRecord record) {
        return this.fill(record, this.blockSize);
    }

    abstract DynamicRecord fill(DynamicRecord var1, int var2);

    abstract DynamicRecord record(long var1);

    public static RecordStore<DynamicRecord> configureDynamicStore(int blockSize) {
        RecordStore mock = (RecordStore)Mockito.mock(RecordStore.class);
        Mockito.when((Object)mock.getRecordSize()).thenReturn((Object)(blockSize + 8));
        Mockito.when((Object)mock.getRecordHeaderSize()).thenReturn((Object)8);
        return mock;
    }

    @RunWith(value=JUnit4.class)
    public static class SchemaDynamicRecordCheckTest
    extends DynamicRecordCheckTest {
        public SchemaDynamicRecordCheckTest() {
            super(new DynamicRecordCheck(SchemaDynamicRecordCheckTest.configureDynamicStore(56), DynamicStore.SCHEMA), 56);
        }

        @Override
        DynamicRecord record(long id) {
            DynamicRecord result = new DynamicRecord(id);
            result.setType(255);
            return result;
        }

        @Override
        DynamicRecord fill(DynamicRecord record, int size) {
            record.setLength(size);
            return record;
        }
    }

    @RunWith(value=JUnit4.class)
    public static class ArrayDynamicRecordCheckTest
    extends DynamicRecordCheckTest {
        public ArrayDynamicRecordCheckTest() {
            super(new DynamicRecordCheck(ArrayDynamicRecordCheckTest.configureDynamicStore(66), DynamicStore.ARRAY), 66);
        }

        @Override
        DynamicRecord record(long id) {
            return ArrayDynamicRecordCheckTest.array(new DynamicRecord(id));
        }

        @Override
        DynamicRecord fill(DynamicRecord record, int size) {
            record.setLength(size);
            return record;
        }
    }

    @RunWith(value=JUnit4.class)
    public static class StringDynamicRecordCheckTest
    extends DynamicRecordCheckTest {
        public StringDynamicRecordCheckTest() {
            super(new DynamicRecordCheck(StringDynamicRecordCheckTest.configureDynamicStore(66), DynamicStore.STRING), 66);
        }

        @Override
        DynamicRecord record(long id) {
            return StringDynamicRecordCheckTest.string(new DynamicRecord(id));
        }

        @Override
        DynamicRecord fill(DynamicRecord record, int size) {
            record.setLength(size);
            return record;
        }
    }
}

