/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.TransactionWriter;
import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.consistency.statistics.AccessStatsKeepingStoreAccess;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.statistics.DefaultCounts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.statistics.VerboseStatistics;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.index.lucene.LuceneLabelScanStoreBuilder;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public abstract class GraphStoreFixture
extends PageCacheRule
implements TestRule {
    private DirectStoreAccess directStoreAccess;
    private Statistics statistics;
    private final boolean keepStatistics;
    private NeoStores neoStore;
    private File directory;
    private long schemaId;
    private long nodeId;
    private int labelId;
    private long nodeLabelsId;
    private long relId;
    private long relGroupId;
    private int propId;
    private long stringPropId;
    private long arrayPropId;
    private int relTypeId;
    private int propKeyId;

    public GraphStoreFixture(boolean keepStatistics) {
        this.keepStatistics = keepStatistics;
    }

    public GraphStoreFixture() {
        this(false);
    }

    public void apply(Transaction transaction) throws TransactionFailureException {
        this.applyTransaction(transaction);
    }

    public DirectStoreAccess directStoreAccess() {
        if (this.directStoreAccess == null) {
            StoreAccess nativeStores;
            DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
            PageCache pageCache = this.getPageCache((FileSystemAbstraction)fileSystem);
            this.neoStore = new StoreFactory((FileSystemAbstraction)fileSystem, this.directory, pageCache, (LogProvider)NullLogProvider.getInstance()).openAllNeoStores();
            if (this.keepStatistics) {
                AccessStatistics accessStatistics = new AccessStatistics();
                this.statistics = new VerboseStatistics(accessStatistics, (Counts)new DefaultCounts(ConsistencyCheckService.defaultConsistencyCheckThreadsNumber()), (Log)NullLog.getInstance());
                nativeStores = new AccessStatsKeepingStoreAccess(this.neoStore, accessStatistics);
            } else {
                this.statistics = Statistics.NONE;
                nativeStores = new StoreAccess(this.neoStore);
            }
            nativeStores.initialize();
            this.directStoreAccess = new DirectStoreAccess(nativeStores, new LuceneLabelScanStoreBuilder(this.directory, nativeStores.getRawNeoStores(), (FileSystemAbstraction)fileSystem, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out)).build(), this.createIndexes((FileSystemAbstraction)fileSystem));
        }
        return this.directStoreAccess;
    }

    private SchemaIndexProvider createIndexes(FileSystemAbstraction fileSystem) {
        return new LuceneSchemaIndexProvider(fileSystem, DirectoryFactory.PERSISTENT, this.directory);
    }

    public File directory() {
        return this.directory;
    }

    public Statistics getAccessStatistics() {
        return this.statistics;
    }

    public IdGenerator idGenerator() {
        return new IdGenerator();
    }

    protected abstract void generateInitialData(GraphDatabaseService var1);

    protected void start(File storeDir) {
    }

    protected void stop() throws Throwable {
        if (this.directStoreAccess != null) {
            this.neoStore.close();
            this.directStoreAccess.close();
            this.directStoreAccess = null;
        }
    }

    protected int myId() {
        return 1;
    }

    protected int masterId() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyTransaction(Transaction transaction) throws TransactionFailureException {
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.directory);
        GraphDatabaseAPI database = (GraphDatabaseAPI)builder.newGraphDatabase();
        try (LockGroup locks = new LockGroup();){
            DependencyResolver dependencyResolver = database.getDependencyResolver();
            TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)dependencyResolver.resolveDependency(TransactionAppender.class), (TransactionRepresentationStoreApplier)dependencyResolver.resolveDependency(TransactionRepresentationStoreApplier.class), (IndexUpdatesValidator)dependencyResolver.resolveDependency(IndexUpdatesValidator.class));
            TransactionIdStore transactionIdStore = (TransactionIdStore)database.getDependencyResolver().resolveDependency(TransactionIdStore.class);
            NodeStore nodes = ((NeoStores)database.getDependencyResolver().resolveDependency(NeoStores.class)).getNodeStore();
            commitProcess.commit(transaction.representation(this.idGenerator(), this.masterId(), this.myId(), transactionIdStore.getLastCommittedTransactionId(), nodes), locks, CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        }
        finally {
            database.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateInitialData() {
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.directory);
        GraphDatabaseAPI graphDb = (GraphDatabaseAPI)builder.newGraphDatabase();
        try {
            this.generateInitialData((GraphDatabaseService)graphDb);
            StoreAccess stores = new StoreAccess(graphDb).initialize();
            this.schemaId = stores.getSchemaStore().getHighId();
            this.nodeId = stores.getNodeStore().getHighId();
            this.labelId = (int)stores.getLabelTokenStore().getHighId();
            this.nodeLabelsId = stores.getNodeDynamicLabelStore().getHighId();
            this.relId = stores.getRelationshipStore().getHighId();
            this.relGroupId = stores.getRelationshipGroupStore().getHighId();
            this.propId = (int)stores.getPropertyStore().getHighId();
            this.stringPropId = stores.getStringStore().getHighId();
            this.arrayPropId = stores.getArrayStore().getHighId();
            this.relTypeId = (int)stores.getRelationshipTypeTokenStore().getHighId();
            this.propKeyId = (int)stores.getPropertyKeyNameStore().getHighId();
        }
        finally {
            graphDb.shutdown();
        }
    }

    public Statement apply(final Statement base, Description description) {
        final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest((Class)description.getTestClass());
        return super.apply(directory.apply(new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                GraphStoreFixture.this.directory = directory.graphDbDir();
                try {
                    GraphStoreFixture.this.generateInitialData();
                    GraphStoreFixture.this.start(GraphStoreFixture.this.directory);
                    try {
                        base.evaluate();
                    }
                    finally {
                        GraphStoreFixture.this.stop();
                    }
                }
                finally {
                    GraphStoreFixture.this.directory = null;
                }
            }
        }, description), description);
    }

    public static final class TransactionDataBuilder {
        private final TransactionWriter writer;
        private final NodeStore nodes;

        public TransactionDataBuilder(TransactionWriter writer, NodeStore nodes) {
            this.writer = writer;
            this.nodes = nodes;
        }

        public void createSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords, SchemaRule rule) {
            this.writer.createSchema(beforeRecords, afterRecords, rule);
        }

        public void propertyKey(int id, String key) {
            this.writer.propertyKey(id, key, id + 1);
        }

        public void nodeLabel(int id, String name) {
            this.writer.label(id, name, id + 1);
        }

        public void relationshipType(int id, String relationshipType) {
            this.writer.relationshipType(id, relationshipType, id + 1);
        }

        public void update(NeoStoreRecord record) {
            this.writer.update(record);
        }

        public void create(NodeRecord node) {
            this.updateCounts(node, 1);
            this.writer.create(node);
        }

        public void update(NodeRecord before, NodeRecord after) {
            this.updateCounts(before, -1);
            this.updateCounts(after, 1);
            this.writer.update(before, after);
        }

        public void delete(NodeRecord node) {
            this.updateCounts(node, -1);
            this.writer.delete(node);
        }

        public void create(RelationshipRecord relationship) {
            this.writer.create(relationship);
        }

        public void update(RelationshipRecord relationship) {
            this.writer.update(relationship);
        }

        public void delete(RelationshipRecord relationship) {
            this.writer.delete(relationship);
        }

        public void create(RelationshipGroupRecord group) {
            this.writer.create(group);
        }

        public void update(RelationshipGroupRecord group) {
            this.writer.update(group);
        }

        public void delete(RelationshipGroupRecord group) {
            this.writer.delete(group);
        }

        public void create(PropertyRecord property) {
            this.writer.create(property);
        }

        public void update(PropertyRecord before, PropertyRecord property) {
            this.writer.update(before, property);
        }

        public void delete(PropertyRecord before, PropertyRecord property) {
            this.writer.delete(before, property);
        }

        private void updateCounts(NodeRecord node, int delta) {
            this.writer.incrementNodeCount(-1, delta);
            for (long label : NodeLabelsField.parseLabelsField((NodeRecord)node).get(this.nodes)) {
                this.writer.incrementNodeCount((int)label, delta);
            }
        }

        public void incrementNodeCount(int labelId, long delta) {
            this.writer.incrementNodeCount(labelId, delta);
        }

        public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
            this.writer.incrementRelationshipCount(startLabelId, typeId, endLabelId, delta);
        }
    }

    public class IdGenerator {
        public long schema() {
            return GraphStoreFixture.this.schemaId++;
        }

        public long node() {
            return GraphStoreFixture.this.nodeId++;
        }

        public int label() {
            return GraphStoreFixture.this.labelId++;
        }

        public long nodeLabel() {
            return GraphStoreFixture.this.nodeLabelsId++;
        }

        public long relationship() {
            return GraphStoreFixture.this.relId++;
        }

        public long relationshipGroup() {
            return GraphStoreFixture.this.relGroupId++;
        }

        public long property() {
            return GraphStoreFixture.this.propId++;
        }

        public long stringProperty() {
            return GraphStoreFixture.this.stringPropId++;
        }

        public long arrayProperty() {
            return GraphStoreFixture.this.arrayPropId++;
        }

        public int relationshipType() {
            return GraphStoreFixture.this.relTypeId++;
        }

        public int propertyKey() {
            return GraphStoreFixture.this.propKeyId++;
        }
    }

    public static abstract class Transaction {
        public final long startTimestamp = System.currentTimeMillis();

        protected abstract void transactionData(TransactionDataBuilder var1, IdGenerator var2);

        public TransactionRepresentation representation(IdGenerator idGenerator, int masterId, int authorId, long lastCommittedTx, NodeStore nodes) {
            TransactionWriter writer = new TransactionWriter();
            this.transactionData(new TransactionDataBuilder(writer, nodes), idGenerator);
            return writer.representation(new byte[0], masterId, authorId, this.startTimestamp, lastCommittedTx, System.currentTimeMillis());
        }
    }
}

