/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.NodeField;
import org.neo4j.consistency.checking.PropertyChain;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.checking.RelationshipRecordCheck;
import org.neo4j.consistency.checking.full.CheckStage;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.function.Functions;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

public class RelationshipRecordCheckTest
extends RecordCheckTestBase<RelationshipRecord, ConsistencyReport.RelationshipConsistencyReport, RelationshipRecordCheck> {
    private boolean checkSingleDirection;

    public RelationshipRecordCheckTest() {
        super(new RelationshipRecordCheck(new RecordField[]{RelationshipRecordCheck.RelationshipTypeField.RELATIONSHIP_TYPE, NodeField.SOURCE, RelationshipRecordCheck.RelationshipField.SOURCE_PREV, RelationshipRecordCheck.RelationshipField.SOURCE_NEXT, NodeField.TARGET, RelationshipRecordCheck.RelationshipField.TARGET_PREV, RelationshipRecordCheck.RelationshipField.TARGET_NEXT, new PropertyChain(Functions.nullFunction())}), ConsistencyReport.RelationshipConsistencyReport.class, CheckStage.Stage6_RS_Forward.getCacheSlotSizes(), MultiPassStore.RELATIONSHIPS);
    }

    private void checkSingleDirection() {
        this.checkSingleDirection = true;
    }

    @Override
    final ConsistencyReport.RelationshipConsistencyReport check(RelationshipRecord record) {
        this.records.populateCache();
        ConsistencyReport.RelationshipConsistencyReport report = (ConsistencyReport.RelationshipConsistencyReport)Mockito.mock(ConsistencyReport.RelationshipConsistencyReport.class);
        this.records.cacheAccess().setCacheSlotSizes(CheckStage.Stage6_RS_Forward.getCacheSlotSizes());
        super.check(report, record);
        if (!this.checkSingleDirection) {
            this.records.cacheAccess().setForward(!this.records.cacheAccess().isForward());
            super.check(report, record);
        }
        return report;
    }

    @Test
    public void shouldNotReportAnythingForRelationshipNotInUse() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.notInUse(new RelationshipRecord(42L, 0L, 0L, 0));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldNotReportAnythingForRelationshipThatDoesNotReferenceOtherRecords() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldNotReportAnythingForRelationshipWithConsistentReferences() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, relationship.getId(), -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 53L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(3L, false, -1L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new PropertyRecord(101L)));
        relationship.setNextProp(101L);
        RelationshipRecord sNext = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 1L, 3L, 4)));
        RelationshipRecord tNext = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(52L, 2L, 3L, 4)));
        RelationshipRecord tPrev = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(53L, 3L, 2L, 4)));
        relationship.setFirstNextRel(sNext.getId());
        sNext.setFirstPrevRel(relationship.getId());
        sNext.setFirstInFirstChain(false);
        relationship.setSecondNextRel(tNext.getId());
        tNext.setFirstPrevRel(relationship.getId());
        tNext.setFirstInFirstChain(false);
        relationship.setSecondPrevRel(tPrev.getId());
        relationship.setFirstInSecondChain(false);
        tPrev.setSecondNextRel(relationship.getId());
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportIllegalRelationshipType() throws Exception {
        this.checkSingleDirection();
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, -1));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).illegalRelationshipType();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportRelationshipTypeNotInUse() throws Exception {
        this.checkSingleDirection();
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        RelationshipTypeTokenRecord relationshipType = this.add(RelationshipRecordCheckTest.notInUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).relationshipTypeNotInUse(relationshipType);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportIllegalSourceNode() throws Exception {
        this.checkSingleDirection();
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, -1L, 1L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).illegalSourceNode();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSourceNodeNotInUse() throws Exception {
        this.checkSingleDirection();
        this.initialize(MultiPassStore.RELATIONSHIPS, MultiPassStore.NODES);
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        NodeRecord node = this.add(RelationshipRecordCheckTest.notInUse(new NodeRecord(1L, false, -1L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).sourceNodeNotInUse(node);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportIllegalTargetNode() throws Exception {
        this.checkSingleDirection();
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, -1L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).illegalTargetNode();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportTargetNodeNotInUse() throws Exception {
        this.checkSingleDirection();
        this.initialize(MultiPassStore.RELATIONSHIPS, MultiPassStore.NODES);
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        NodeRecord node = this.add(RelationshipRecordCheckTest.notInUse(new NodeRecord(2L, false, -1L, -1L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).targetNodeNotInUse(node);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportPropertyNotInUse() throws Exception {
        this.checkSingleDirection();
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        relationship.setNextProp(11L);
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        PropertyRecord property = this.add(RelationshipRecordCheckTest.notInUse(new PropertyRecord(11L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).propertyNotInUse(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportPropertyNotFirstInChain() throws Exception {
        this.checkSingleDirection();
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        relationship.setNextProp(11L);
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        PropertyRecord property = this.add(RelationshipRecordCheckTest.inUse(new PropertyRecord(11L)));
        property.setPrevProp(6L);
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).propertyNotFirstInChain(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSourceNodeNotReferencingBackForFirstRelationshipInSourceChain() throws Exception {
        this.checkSingleDirection();
        this.initialize(MultiPassStore.RELATIONSHIPS, MultiPassStore.NODES);
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        NodeRecord source = this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 7L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).sourceNodeDoesNotReferenceBack(source);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportTargetNodeNotReferencingBackForFirstRelationshipInTargetChain() throws Exception {
        this.checkSingleDirection();
        this.initialize(MultiPassStore.RELATIONSHIPS, MultiPassStore.NODES);
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        NodeRecord target = this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 7L, -1L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).targetNodeDoesNotReferenceBack(target);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSourceAndTargetNodeNotReferencingBackForFirstRelationshipInChains() throws Exception {
        this.checkSingleDirection();
        this.initialize(MultiPassStore.RELATIONSHIPS, MultiPassStore.NODES);
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        NodeRecord source = this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, -1L, -1L)));
        NodeRecord target = this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, -1L, -1L)));
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).sourceNodeDoesNotReferenceBack(source);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).targetNodeDoesNotReferenceBack(target);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSourceNodeWithoutChainForRelationshipInTheMiddleOfChain() throws Exception {
        this.checkSingleDirection();
        this.initialize(MultiPassStore.RELATIONSHIPS, MultiPassStore.NODES);
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        NodeRecord source = this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, -1L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        RelationshipRecord sPrev = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 1L, 0L, 0)));
        relationship.setFirstPrevRel(sPrev.getId());
        relationship.setFirstInFirstChain(false);
        sPrev.setFirstNextRel(relationship.getId());
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).sourceNodeHasNoRelationships(source);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportTargetNodeWithoutChainForRelationshipInTheMiddleOfChain() throws Exception {
        this.checkSingleDirection();
        this.initialize(MultiPassStore.RELATIONSHIPS, MultiPassStore.NODES);
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        NodeRecord target = this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, -1L, -1L)));
        RelationshipRecord tPrev = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 0L, 2L, 0)));
        relationship.setSecondPrevRel(tPrev.getId());
        relationship.setFirstInSecondChain(false);
        tPrev.setSecondNextRel(relationship.getId());
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).targetNodeHasNoRelationships(target);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSourcePrevReferencingOtherNodes() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 0L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        RelationshipRecord sPrev = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 8L, 9L, 0)));
        relationship.setFirstPrevRel(sPrev.getId());
        relationship.setFirstInFirstChain(false);
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).sourcePrevReferencesOtherNodes(sPrev);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportTargetPrevReferencingOtherNodes() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 0L, -1L)));
        RelationshipRecord tPrev = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 8L, 9L, 0)));
        relationship.setSecondPrevRel(tPrev.getId());
        relationship.setFirstInSecondChain(false);
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).targetPrevReferencesOtherNodes(tPrev);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSourceNextReferencingOtherNodes() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        RelationshipRecord sNext = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 8L, 9L, 0)));
        relationship.setFirstNextRel(sNext.getId());
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).sourceNextReferencesOtherNodes(sNext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportTargetNextReferencingOtherNodes() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        RelationshipRecord tNext = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 8L, 9L, 0)));
        relationship.setSecondNextRel(tNext.getId());
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).targetNextReferencesOtherNodes(tNext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSourcePrevReferencingOtherNodesWhenReferencingTargetNode() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 0L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        RelationshipRecord sPrev = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 2L, 0L, 0)));
        relationship.setFirstPrevRel(sPrev.getId());
        relationship.setFirstInFirstChain(false);
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).sourcePrevReferencesOtherNodes(sPrev);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportTargetPrevReferencingOtherNodesWhenReferencingSourceNode() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 0L, -1L)));
        RelationshipRecord tPrev = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 1L, 0L, 0)));
        relationship.setSecondPrevRel(tPrev.getId());
        relationship.setFirstInSecondChain(false);
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).targetPrevReferencesOtherNodes(tPrev);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSourceNextReferencingOtherNodesWhenReferencingTargetNode() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        RelationshipRecord sNext = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 2L, 0L, 0)));
        relationship.setFirstNextRel(sNext.getId());
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).sourceNextReferencesOtherNodes(sNext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportTargetNextReferencingOtherNodesWhenReferencingSourceNode() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        RelationshipRecord tNext = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 1L, 0L, 0)));
        relationship.setSecondNextRel(tNext.getId());
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).targetNextReferencesOtherNodes(tNext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSourcePrevNotReferencingBack() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 0L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        RelationshipRecord sPrev = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 1L, 3L, 0)));
        relationship.setFirstPrevRel(sPrev.getId());
        relationship.setFirstInFirstChain(false);
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).sourcePrevDoesNotReferenceBack(sPrev);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportTargetPrevNotReferencingBack() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 0L, -1L)));
        RelationshipRecord tPrev = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 2L, 3L, 0)));
        relationship.setSecondPrevRel(tPrev.getId());
        relationship.setFirstInSecondChain(false);
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).targetPrevDoesNotReferenceBack(tPrev);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportSourceNextNotReferencingBack() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        RelationshipRecord sNext = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 3L, 1L, 0)));
        relationship.setFirstNextRel(sNext.getId());
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).sourceNextDoesNotReferenceBack(sNext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportTargetNextNotReferencingBack() throws Exception {
        RelationshipRecord relationship = RelationshipRecordCheckTest.inUse(new RelationshipRecord(42L, 1L, 2L, 4));
        this.add(RelationshipRecordCheckTest.inUse(new RelationshipTypeTokenRecord(4)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(1L, false, 42L, -1L)));
        this.add(RelationshipRecordCheckTest.inUse(new NodeRecord(2L, false, 42L, -1L)));
        RelationshipRecord tNext = this.add(RelationshipRecordCheckTest.inUse(new RelationshipRecord(51L, 3L, 2L, 0)));
        relationship.setSecondNextRel(tNext.getId());
        ConsistencyReport.RelationshipConsistencyReport report = this.check(relationship);
        ((ConsistencyReport.RelationshipConsistencyReport)Mockito.verify((Object)report)).targetNextDoesNotReferenceBack(tNext);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }
}

