/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.test.RandomRule;
import org.neo4j.test.TargetDirectory;

public class DetectAllRelationshipInconsistenciesIT {
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    public final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.directory);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDetectSabotagedRelationshipWhereEverItIs() throws Exception {
        Sabotage sabotage;
        GraphDatabaseAPI db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabase(this.directory.absolutePath());
        try {
            Object[] nodes = new Node[1000];
            Object[] relationships = new Relationship[10000];
            try (Transaction tx = db.beginTx();){
                int i;
                for (i = 0; i < nodes.length; ++i) {
                    nodes[i] = db.createNode();
                }
                for (i = 0; i < 10000; ++i) {
                    relationships[i] = ((Node)this.random.among(nodes)).createRelationshipTo((Node)this.random.among(nodes), (RelationshipType)MyRelTypes.TEST);
                }
                tx.success();
            }
            NeoStores neoStores = (NeoStores)db.getDependencyResolver().resolveDependency(NeoStores.class);
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            Relationship sabotagedRelationships = (Relationship)this.random.among(relationships);
            sabotage = this.sabotage(relationshipStore, sabotagedRelationships.getId());
        }
        finally {
            db.shutdown();
        }
        db = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabase(this.directory.absolutePath());
        try {
            StoreAccess storeAccess = new StoreAccess(db).initialize();
            DirectStoreAccess directStoreAccess = new DirectStoreAccess(storeAccess, (LabelScanStore)db.getDependencyResolver().resolveDependency(LabelScanStore.class), (SchemaIndexProvider)db.getDependencyResolver().resolveDependency(SchemaIndexProvider.class));
            int threads = this.random.intBetween(2, 10);
            FullCheck checker = new FullCheck(new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m"})), ProgressMonitorFactory.NONE, Statistics.NONE, threads);
            AssertableLogProvider logProvider = new AssertableLogProvider(true);
            ConsistencySummaryStatistics summary = checker.execute(directStoreAccess, logProvider.getLog(FullCheck.class));
            int relationshipInconsistencies = summary.getInconsistencyCountForRecordType(RecordType.RELATIONSHIP);
            Assert.assertTrue((String)("Couldn't detect sabotaged relationship " + sabotage), (relationshipInconsistencies > 0 ? 1 : 0) != 0);
            logProvider.assertContainsLogCallContaining(sabotage.after.toString());
        }
        finally {
            db.shutdown();
        }
    }

    private Sabotage sabotage(RelationshipStore relationshipStore, long id) {
        long otherReference;
        RelationshipRecord before = relationshipStore.getRecord(id);
        RelationshipRecord after = before.clone();
        if (!after.isFirstInFirstChain()) {
            otherReference = after.getFirstPrevRel() + 1L;
            after.setFirstPrevRel(otherReference);
        } else {
            otherReference = after.getFirstNextRel() + 1L;
            after.setFirstNextRel(otherReference);
        }
        relationshipStore.updateRecord(after);
        RelationshipRecord other = relationshipStore.forceGetRecord(otherReference);
        return new Sabotage(before, after, other);
    }

    private static class Sabotage {
        private final RelationshipRecord before;
        private final RelationshipRecord after;
        private final RelationshipRecord other;

        Sabotage(RelationshipRecord before, RelationshipRecord after, RelationshipRecord other) {
            this.before = before;
            this.after = after;
            this.other = other;
        }

        public String toString() {
            return "Sabotabed " + this.before + " --> " + this.after + ", other relationship " + this.other;
        }
    }
}

