/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Arrays;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.IterableStore;
import org.neo4j.consistency.checking.full.ParallelRecordScanner;
import org.neo4j.consistency.checking.full.QueueDistribution;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.checking.full.SequentialRecordScanner;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.helpers.progress.ProgressListener;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.api.direct.BoundedIterable;

public class RecordScannerTest {
    @Test
    public void shouldProcessRecordsSequentiallyAndUpdateProgress() throws Exception {
        ProgressMonitorFactory.MultiPartBuilder progressBuilder = (ProgressMonitorFactory.MultiPartBuilder)Mockito.mock(ProgressMonitorFactory.MultiPartBuilder.class);
        ProgressListener progressListener = (ProgressListener)Mockito.mock(ProgressListener.class);
        Mockito.when((Object)progressBuilder.progressForPart(Matchers.anyString(), Matchers.anyLong())).thenReturn((Object)progressListener);
        BoundedIterable store = (BoundedIterable)Mockito.mock(BoundedIterable.class);
        Mockito.when((Object)store.iterator()).thenReturn(Arrays.asList(42, 75, 192).iterator());
        RecordProcessor recordProcessor = (RecordProcessor)Mockito.mock(RecordProcessor.class);
        SequentialRecordScanner scanner = new SequentialRecordScanner("our test task", Statistics.NONE, 1, store, progressBuilder, recordProcessor, new IterableStore[0]);
        scanner.run();
        this.verifyProcessCloseAndDone((RecordProcessor<Integer>)recordProcessor, (BoundedIterable<Integer>)store, progressListener);
    }

    @Test
    public void shouldProcessRecordsParallelAndUpdateProgress() throws Exception {
        ProgressMonitorFactory.MultiPartBuilder progressBuilder = (ProgressMonitorFactory.MultiPartBuilder)Mockito.mock(ProgressMonitorFactory.MultiPartBuilder.class);
        ProgressListener progressListener = (ProgressListener)Mockito.mock(ProgressListener.class);
        Mockito.when((Object)progressBuilder.progressForPart(Matchers.anyString(), Matchers.anyLong())).thenReturn((Object)progressListener);
        BoundedIterable store = (BoundedIterable)Mockito.mock(BoundedIterable.class);
        Mockito.when((Object)store.iterator()).thenReturn(Arrays.asList(42, 75, 192).iterator());
        RecordProcessor recordProcessor = (RecordProcessor)Mockito.mock(RecordProcessor.class);
        ParallelRecordScanner scanner = new ParallelRecordScanner("our test task", Statistics.NONE, 1, store, progressBuilder, recordProcessor, CacheAccess.EMPTY, QueueDistribution.ROUND_ROBIN, new IterableStore[0]);
        scanner.run();
        this.verifyProcessCloseAndDone((RecordProcessor<Integer>)recordProcessor, (BoundedIterable<Integer>)store, progressListener);
    }

    private void verifyProcessCloseAndDone(RecordProcessor<Integer> recordProcessor, BoundedIterable<Integer> store, ProgressListener progressListener) throws Exception {
        ((RecordProcessor)Mockito.verify(recordProcessor)).process((Object)42);
        ((RecordProcessor)Mockito.verify(recordProcessor)).process((Object)75);
        ((RecordProcessor)Mockito.verify(recordProcessor)).process((Object)192);
        ((RecordProcessor)Mockito.verify(recordProcessor)).close();
        ((BoundedIterable)Mockito.verify(store)).close();
        ((ProgressListener)Mockito.verify((Object)progressListener, (VerificationMode)Mockito.times((int)3))).add(1L);
        ((ProgressListener)Mockito.verify((Object)progressListener)).done();
    }
}

