/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.store.paging;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.consistency.store.paging.Cart;
import org.neo4j.consistency.store.paging.Page;
import org.neo4j.consistency.store.paging.PageReplacementStrategy;

public class CartTest {
    @Test
    public void linearScanWithSingleHitPerWindowLeadsToFifoEviction() throws Exception {
        int capacity = 10;
        StorageSpy storage = new StorageSpy(capacity * 2);
        Cart cart = new Cart(capacity);
        for (int i = 0; i < capacity * 2; ++i) {
            cart.acquire((Page)storage.page(i), (PageReplacementStrategy.Storage)storage);
        }
        Assert.assertArrayEquals((Object[])new String[]{"L0", "L1", "L2", "L3", "L4", "L5", "L6", "L7", "L8", "L9", "E0", "L10", "E1", "L11", "E2", "L12", "E3", "L13", "E4", "L14", "E5", "L15", "E6", "L16", "E7", "L17", "E8", "L18", "E9", "L19"}, (Object[])storage.events.toArray());
    }

    @Test
    public void reverseLinearScanWithSingleHitPerWindowLeadsToFifoEviction() throws Exception {
        int capacity = 10;
        StorageSpy storage = new StorageSpy(capacity * 2);
        Cart cart = new Cart(capacity);
        for (int i = capacity * 2 - 1; i >= 0; --i) {
            cart.acquire((Page)storage.page(i), (PageReplacementStrategy.Storage)storage);
        }
        Assert.assertArrayEquals((Object[])new String[]{"L19", "L18", "L17", "L16", "L15", "L14", "L13", "L12", "L11", "L10", "E19", "L9", "E18", "L8", "E17", "L7", "E16", "L6", "E15", "L5", "E14", "L4", "E13", "L3", "E12", "L2", "E11", "L1", "E10", "L0"}, (Object[])storage.events.toArray());
    }

    @Test
    public void frequentlyAccessedPagesDoNotGetEvicted() throws Exception {
        int capacity = 10;
        StorageSpy storage = new StorageSpy(capacity * 2);
        Cart cart = new Cart(capacity);
        for (int i = 0; i < capacity * 2; ++i) {
            cart.acquire((Page)storage.page(i / 2 * 2), (PageReplacementStrategy.Storage)storage);
            cart.acquire((Page)storage.page(i), (PageReplacementStrategy.Storage)storage);
        }
        Assert.assertThat(storage.events, (Matcher)IsNot.not((Matcher)CoreMatchers.hasItem((Object)"E0")));
        Assert.assertThat(storage.events, (Matcher)CoreMatchers.hasItem((Object)"E1"));
        Assert.assertThat(storage.events, (Matcher)IsNot.not((Matcher)CoreMatchers.hasItem((Object)"E2")));
        Assert.assertThat(storage.events, (Matcher)CoreMatchers.hasItem((Object)"E3"));
        Assert.assertThat(storage.events, (Matcher)IsNot.not((Matcher)CoreMatchers.hasItem((Object)"E4")));
        Assert.assertThat(storage.events, (Matcher)CoreMatchers.hasItem((Object)"E5"));
        Assert.assertThat(storage.events, (Matcher)IsNot.not((Matcher)CoreMatchers.hasItem((Object)"E6")));
        Assert.assertThat(storage.events, (Matcher)CoreMatchers.hasItem((Object)"E7"));
        Assert.assertThat(storage.events, (Matcher)IsNot.not((Matcher)CoreMatchers.hasItem((Object)"E8")));
        Assert.assertThat(storage.events, (Matcher)CoreMatchers.hasItem((Object)"E9"));
    }

    @Test
    public void linearPlusRandom() throws Exception {
        int capacity = 100;
        StorageSpy storage = new StorageSpy(capacity * 2);
        int randoms = 4;
        int pageSize = 10;
        Cart cart = new Cart(capacity);
        Random random = new Random();
        for (int i = 0; i < capacity * 2; ++i) {
            for (int j = 0; j < pageSize; ++j) {
                storage.linear = true;
                cart.acquire((Page)storage.page(i), (PageReplacementStrategy.Storage)storage);
                storage.linear = false;
                for (int k = 0; k < randoms; ++k) {
                    cart.acquire((Page)storage.page(random.nextInt(capacity * 2)), (PageReplacementStrategy.Storage)storage);
                }
            }
        }
        Assert.assertTrue((storage.linMiss * pageSize <= storage.linMiss + storage.linHit ? 1 : 0) != 0);
        Assert.assertTrue(((double)(storage.rndMiss * 2) <= (double)(storage.rndMiss + storage.rndHit) * 1.05 ? 1 : 0) != 0);
    }

    @Test
    public void shouldReloadAfterForcedEviction() throws Exception {
        int capacity = 10;
        StorageSpy storage = new StorageSpy(capacity * 2);
        Cart cart = new Cart(capacity);
        cart.acquire((Page)storage.page(0), (PageReplacementStrategy.Storage)storage);
        cart.forceEvict((Page)storage.page(0));
        cart.acquire((Page)storage.page(0), (PageReplacementStrategy.Storage)storage);
        Assert.assertArrayEquals((Object[])new String[]{"L0", "E0", "L0"}, (Object[])storage.events.toArray());
    }

    private static class StorageSpy
    implements PageReplacementStrategy.Storage<Integer, SpyPage> {
        SpyPage[] pages;
        List<String> events = new ArrayList<String>();
        int hitCount;
        int loadCount;
        boolean linear;
        int linHit;
        int linMiss;
        int rndHit;
        int rndMiss;

        StorageSpy(int pageCount) {
            this.pages = new SpyPage[pageCount];
            for (int i = 0; i < this.pages.length; ++i) {
                this.pages[i] = new SpyPage(i);
            }
        }

        public Integer load(SpyPage page) {
            this.events.add("L" + page.address);
            ++this.loadCount;
            if (this.linear) {
                ++this.linMiss;
            } else {
                ++this.rndMiss;
            }
            return page.address;
        }

        public SpyPage page(int address) {
            return this.pages[address];
        }

        class SpyPage
        extends Page<Integer> {
            private final int address;

            public SpyPage(int address) {
                this.address = address;
            }

            protected void evict(Integer address) {
                StorageSpy.this.events.add("E" + address);
            }

            protected void hit() {
                ++StorageSpy.this.hitCount;
                if (StorageSpy.this.linear) {
                    ++StorageSpy.this.linHit;
                } else {
                    ++StorageSpy.this.rndHit;
                }
            }
        }
    }
}

