/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.LabelsMatchCheck;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class NodeToLabelScanRecordProcessor
extends RecordProcessor.Adapter<NodeRecord> {
    private final ConsistencyReporter reporter;
    private final RecordCheck<NodeRecord, ConsistencyReport.LabelsMatchReport> nodeLabelCheck;
    private final LabelScanReader reader;

    public NodeToLabelScanRecordProcessor(ConsistencyReporter reporter, LabelScanStore labelScanStore) {
        this.reporter = reporter;
        this.reader = labelScanStore.newReader();
        this.nodeLabelCheck = new LabelsMatchCheck(this.reader);
    }

    @Override
    public void process(NodeRecord nodeRecord) {
        this.reporter.forNodeLabelMatch(nodeRecord, this.nodeLabelCheck);
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

