/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.function.Suppliers;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;

public class PropertyReader
implements PropertyAccessor {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;

    public PropertyReader(StoreAccess storeAccess) {
        this.propertyStore = storeAccess.getRawNeoStores().getPropertyStore();
        this.nodeStore = storeAccess.getRawNeoStores().getNodeStore();
    }

    public Collection<PropertyRecord> getPropertyRecordChain(NodeRecord nodeRecord) {
        return this.getPropertyRecordChain(nodeRecord.getNextProp());
    }

    public Collection<PropertyRecord> getPropertyRecordChain(long firstId) {
        long nextProp = firstId;
        LinkedList<PropertyRecord> toReturn = new LinkedList<PropertyRecord>();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = (PropertyRecord)this.propertyStore.getRecord(nextProp, (AbstractBaseRecord)this.propertyStore.newRecord(), RecordLoad.FORCE);
            toReturn.add(propRecord);
            nextProp = propRecord.getNextProp();
        }
        return toReturn;
    }

    public List<PropertyBlock> propertyBlocks(Collection<PropertyRecord> records) {
        ArrayList<PropertyBlock> propertyBlocks = new ArrayList<PropertyBlock>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record) {
                propertyBlocks.add(block);
            }
        }
        return propertyBlocks;
    }

    public List<PropertyBlock> propertyBlocks(NodeRecord nodeRecord) {
        Collection records = this.propertyStore.getPropertyRecordChain(nodeRecord.getNextProp());
        ArrayList<PropertyBlock> propertyBlocks = new ArrayList<PropertyBlock>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record) {
                propertyBlocks.add(block);
            }
        }
        return propertyBlocks;
    }

    public DefinedProperty propertyValue(PropertyBlock block) {
        return block.getType().readProperty(block.getKeyIndexId(), block, Suppliers.singleton((Object)this.propertyStore));
    }

    public Property getProperty(long nodeId, int propertyKeyId) {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        if (((NodeRecord)this.nodeStore.getRecord(nodeId, (AbstractBaseRecord)nodeRecord, RecordLoad.FORCE)).inUse()) {
            for (PropertyBlock block : this.propertyBlocks(nodeRecord)) {
                if (block.getKeyIndexId() != propertyKeyId) continue;
                return this.propertyValue(block);
            }
        }
        return Property.noNodeProperty((long)nodeId, (int)propertyKeyId);
    }
}

