/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.NeoStoreCheck;
import org.neo4j.consistency.checking.PropertyChain;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.RecordField;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;

public class MetaDataStoreCheckTest
extends RecordCheckTestBase<NeoStoreRecord, ConsistencyReport.NeoStoreConsistencyReport, NeoStoreCheck> {
    public MetaDataStoreCheckTest() {
        super(new NeoStoreCheck(new RecordField[]{new PropertyChain(from -> null)}), ConsistencyReport.NeoStoreConsistencyReport.class, new int[0], new MultiPassStore[0]);
    }

    @Test
    public void shouldNotReportAnythingForRecordWithNoPropertyReference() throws Exception {
        NeoStoreRecord record = new NeoStoreRecord();
        ConsistencyReport.NeoStoreConsistencyReport report = (ConsistencyReport.NeoStoreConsistencyReport)this.check(record);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldNotReportAnythingForRecordWithConsistentReferenceToProperty() throws Exception {
        NeoStoreRecord record = new NeoStoreRecord();
        record.setNextProp(this.add(MetaDataStoreCheckTest.inUse(new PropertyRecord(7L))).getId());
        ConsistencyReport.NeoStoreConsistencyReport report = (ConsistencyReport.NeoStoreConsistencyReport)this.check(record);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportPropertyNotInUse() throws Exception {
        NeoStoreRecord record = new NeoStoreRecord();
        PropertyRecord property = this.add(MetaDataStoreCheckTest.notInUse(new PropertyRecord(7L)));
        record.setNextProp(property.getId());
        ConsistencyReport.NeoStoreConsistencyReport report = (ConsistencyReport.NeoStoreConsistencyReport)this.check(record);
        ((ConsistencyReport.NeoStoreConsistencyReport)Mockito.verify((Object)report)).propertyNotInUse(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportPropertyNotFirstInChain() throws Exception {
        NeoStoreRecord record = new NeoStoreRecord();
        PropertyRecord property = this.add(MetaDataStoreCheckTest.inUse(new PropertyRecord(7L)));
        property.setPrevProp(6L);
        record.setNextProp(property.getId());
        ConsistencyReport.NeoStoreConsistencyReport report = (ConsistencyReport.NeoStoreConsistencyReport)this.check(record);
        ((ConsistencyReport.NeoStoreConsistencyReport)Mockito.verify((Object)report)).propertyNotFirstInChain(property);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }
}

