/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.SchemaRecordCheck;
import org.neo4j.consistency.checking.SchemaRuleUtil;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaRecordCheckTest
extends RecordCheckTestBase<DynamicRecord, ConsistencyReport.SchemaConsistencyReport, SchemaRecordCheck> {
    private final int labelId = 1;
    private final int propertyKeyId = 2;

    public SchemaRecordCheckTest() {
        super(new SchemaRecordCheck((SchemaRuleAccess)SchemaRecordCheckTest.configureSchemaStore(), SchemaRecordCheckTest.configureIndexAcessors()), ConsistencyReport.SchemaConsistencyReport.class, new int[0], new MultiPassStore[0]);
    }

    private static IndexAccessors configureIndexAcessors() {
        return (IndexAccessors)Mockito.mock(IndexAccessors.class);
    }

    private static SchemaStorage configureSchemaStore() {
        return (SchemaStorage)Mockito.mock(SchemaStorage.class);
    }

    @Test
    public void shouldReportMalformedSchemaRule() throws Exception {
        DynamicRecord badRecord = SchemaRecordCheckTest.inUse(new DynamicRecord(0L));
        badRecord.setType(255);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule(0L)).thenThrow(new Throwable[]{new MalformedSchemaRuleException("Bad Record")});
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(badRecord);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).malformedSchemaRule();
    }

    @Test
    public void shouldReportInvalidLabelReferences() throws Exception {
        int schemaRuleId = 0;
        DynamicRecord record = SchemaRecordCheckTest.inUse(this.dynamicRecord(schemaRuleId));
        SchemaIndexProvider.Descriptor providerDescriptor = new SchemaIndexProvider.Descriptor("in-memory", "1.0");
        IndexRule rule = SchemaRuleUtil.indexRule(schemaRuleId, 1, 2, providerDescriptor);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)schemaRuleId)).thenReturn((Object)rule);
        LabelTokenRecord labelTokenRecord = this.add(SchemaRecordCheckTest.notInUse(new LabelTokenRecord(1)));
        this.add(SchemaRecordCheckTest.inUse(new PropertyKeyTokenRecord(2)));
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(record);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).labelNotInUse(labelTokenRecord);
    }

    @Test
    public void shouldReportInvalidPropertyReferenceFromIndexRule() throws Exception {
        int schemaRuleId = 0;
        DynamicRecord record = SchemaRecordCheckTest.inUse(this.dynamicRecord(schemaRuleId));
        SchemaIndexProvider.Descriptor providerDescriptor = new SchemaIndexProvider.Descriptor("in-memory", "1.0");
        IndexRule rule = SchemaRuleUtil.indexRule(schemaRuleId, 1, 2, providerDescriptor);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)schemaRuleId)).thenReturn((Object)rule);
        this.add(SchemaRecordCheckTest.inUse(new LabelTokenRecord(1)));
        PropertyKeyTokenRecord propertyKeyToken = this.add(SchemaRecordCheckTest.notInUse(new PropertyKeyTokenRecord(2)));
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(record);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).propertyKeyNotInUse(propertyKeyToken);
    }

    @Test
    public void shouldReportInvalidPropertyReferenceFromUniquenessConstraintRule() throws Exception {
        int schemaRuleId = 0;
        int indexRuleId = 1;
        DynamicRecord record = SchemaRecordCheckTest.inUse(this.dynamicRecord(schemaRuleId));
        ConstraintRule rule = SchemaRuleUtil.uniquenessConstraintRule(schemaRuleId, 1, 2, indexRuleId);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)schemaRuleId)).thenReturn((Object)rule);
        this.add(SchemaRecordCheckTest.inUse(new LabelTokenRecord(1)));
        PropertyKeyTokenRecord propertyKeyToken = this.add(SchemaRecordCheckTest.notInUse(new PropertyKeyTokenRecord(2)));
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(record);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).propertyKeyNotInUse(propertyKeyToken);
    }

    @Test
    public void shouldReportUniquenessConstraintNotReferencingBack() throws Exception {
        int ruleId1 = 0;
        int ruleId2 = 1;
        DynamicRecord record1 = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId1));
        DynamicRecord record2 = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId2));
        SchemaIndexProvider.Descriptor providerDescriptor = new SchemaIndexProvider.Descriptor("in-memory", "1.0");
        IndexRule rule1 = SchemaRuleUtil.constraintIndexRule(ruleId1, 1, 2, providerDescriptor, ruleId2);
        ConstraintRule rule2 = SchemaRuleUtil.uniquenessConstraintRule(ruleId2, 1, 2, ruleId2);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId1)).thenReturn((Object)rule1);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId2)).thenReturn((Object)rule2);
        this.add(SchemaRecordCheckTest.inUse(new LabelTokenRecord(1)));
        this.add(SchemaRecordCheckTest.inUse(new PropertyKeyTokenRecord(2)));
        this.check(record1);
        this.check(record2);
        SchemaRecordCheck obligationChecker = ((SchemaRecordCheck)this.checker()).forObligationChecking();
        this.check(obligationChecker, record1);
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(obligationChecker, record2);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).uniquenessConstraintNotReferencingBack(record1);
    }

    @Test
    public void shouldNotReportConstraintIndexRuleWithoutBackReference() throws Exception {
        int ruleId = 1;
        DynamicRecord record = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId));
        SchemaIndexProvider.Descriptor providerDescriptor = new SchemaIndexProvider.Descriptor("in-memory", "1.0");
        IndexRule rule = SchemaRuleUtil.constraintIndexRule(ruleId, 1, 2, providerDescriptor);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId)).thenReturn((Object)rule);
        this.add(SchemaRecordCheckTest.inUse(new LabelTokenRecord(1)));
        this.add(SchemaRecordCheckTest.inUse(new PropertyKeyTokenRecord(2)));
        this.check(record);
        SchemaRecordCheck obligationChecker = ((SchemaRecordCheck)this.checker()).forObligationChecking();
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(obligationChecker, record);
        Mockito.verifyZeroInteractions((Object[])new Object[]{report});
    }

    @Test
    public void shouldReportTwoUniquenessConstraintsReferencingSameIndex() throws Exception {
        int ruleId1 = 0;
        int ruleId2 = 1;
        DynamicRecord record1 = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId1));
        DynamicRecord record2 = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId2));
        ConstraintRule rule1 = SchemaRuleUtil.uniquenessConstraintRule(ruleId1, 1, 2, ruleId2);
        ConstraintRule rule2 = SchemaRuleUtil.uniquenessConstraintRule(ruleId2, 1, 2, ruleId2);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId1)).thenReturn((Object)rule1);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId2)).thenReturn((Object)rule2);
        this.add(SchemaRecordCheckTest.inUse(new LabelTokenRecord(1)));
        this.add(SchemaRecordCheckTest.inUse(new PropertyKeyTokenRecord(2)));
        this.check(record1);
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(record2);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).duplicateObligation(record1);
    }

    @Test
    public void shouldReportUnreferencedUniquenessConstraint() throws Exception {
        int ruleId = 0;
        DynamicRecord record = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId));
        ConstraintRule rule = SchemaRuleUtil.uniquenessConstraintRule(ruleId, 1, 2, ruleId);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId)).thenReturn((Object)rule);
        this.add(SchemaRecordCheckTest.inUse(new LabelTokenRecord(1)));
        this.add(SchemaRecordCheckTest.inUse(new PropertyKeyTokenRecord(2)));
        this.check(record);
        SchemaRecordCheck obligationChecker = ((SchemaRecordCheck)this.checker()).forObligationChecking();
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(obligationChecker, record);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).missingObligation(SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    @Test
    public void shouldReportConstraintIndexNotReferencingBack() throws Exception {
        int ruleId1 = 0;
        int ruleId2 = 1;
        DynamicRecord record1 = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId1));
        DynamicRecord record2 = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId2));
        SchemaIndexProvider.Descriptor providerDescriptor = new SchemaIndexProvider.Descriptor("in-memory", "1.0");
        IndexRule rule1 = SchemaRuleUtil.constraintIndexRule(ruleId1, 1, 2, providerDescriptor, ruleId1);
        ConstraintRule rule2 = SchemaRuleUtil.uniquenessConstraintRule(ruleId2, 1, 2, ruleId1);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId1)).thenReturn((Object)rule1);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId2)).thenReturn((Object)rule2);
        this.add(SchemaRecordCheckTest.inUse(new LabelTokenRecord(1)));
        this.add(SchemaRecordCheckTest.inUse(new PropertyKeyTokenRecord(2)));
        this.check(record1);
        this.check(record2);
        SchemaRecordCheck obligationChecker = ((SchemaRecordCheck)this.checker()).forObligationChecking();
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(obligationChecker, record1);
        this.check(obligationChecker, record2);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).constraintIndexRuleNotReferencingBack(record2);
    }

    @Test
    public void shouldReportTwoConstraintIndexesReferencingSameConstraint() throws Exception {
        int ruleId1 = 0;
        int ruleId2 = 1;
        DynamicRecord record1 = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId1));
        DynamicRecord record2 = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId2));
        SchemaIndexProvider.Descriptor providerDescriptor = new SchemaIndexProvider.Descriptor("in-memory", "1.0");
        IndexRule rule1 = SchemaRuleUtil.constraintIndexRule(ruleId1, 1, 2, providerDescriptor, ruleId1);
        IndexRule rule2 = SchemaRuleUtil.constraintIndexRule(ruleId2, 1, 2, providerDescriptor, ruleId1);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId1)).thenReturn((Object)rule1);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId2)).thenReturn((Object)rule2);
        this.add(SchemaRecordCheckTest.inUse(new LabelTokenRecord(1)));
        this.add(SchemaRecordCheckTest.inUse(new PropertyKeyTokenRecord(2)));
        this.check(record1);
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(record2);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).duplicateObligation(record1);
    }

    @Test
    public void shouldReportUnreferencedConstraintIndex() throws Exception {
        int ruleId = 0;
        DynamicRecord record = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId));
        SchemaIndexProvider.Descriptor providerDescriptor = new SchemaIndexProvider.Descriptor("in-memory", "1.0");
        IndexRule rule = SchemaRuleUtil.constraintIndexRule(ruleId, 1, 2, providerDescriptor, ruleId);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId)).thenReturn((Object)rule);
        this.add(SchemaRecordCheckTest.inUse(new LabelTokenRecord(1)));
        this.add(SchemaRecordCheckTest.inUse(new PropertyKeyTokenRecord(2)));
        this.check(record);
        SchemaRecordCheck obligationChecker = ((SchemaRecordCheck)this.checker()).forObligationChecking();
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(obligationChecker, record);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).missingObligation(SchemaRule.Kind.UNIQUENESS_CONSTRAINT);
    }

    @Test
    public void shouldReportTwoIndexRulesWithDuplicateContent() throws Exception {
        int ruleId1 = 0;
        int ruleId2 = 1;
        DynamicRecord record1 = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId1));
        DynamicRecord record2 = SchemaRecordCheckTest.inUse(this.dynamicRecord(ruleId2));
        SchemaIndexProvider.Descriptor providerDescriptor = new SchemaIndexProvider.Descriptor("in-memory", "1.0");
        IndexRule rule1 = SchemaRuleUtil.constraintIndexRule(ruleId1, 1, 2, providerDescriptor, ruleId1);
        IndexRule rule2 = SchemaRuleUtil.constraintIndexRule(ruleId2, 1, 2, providerDescriptor, ruleId2);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId1)).thenReturn((Object)rule1);
        Mockito.when((Object)((SchemaRecordCheck)this.checker()).ruleAccess.loadSingleSchemaRule((long)ruleId2)).thenReturn((Object)rule2);
        this.add(SchemaRecordCheckTest.inUse(new LabelTokenRecord(1)));
        this.add(SchemaRecordCheckTest.inUse(new PropertyKeyTokenRecord(2)));
        this.check(record1);
        ConsistencyReport.SchemaConsistencyReport report = (ConsistencyReport.SchemaConsistencyReport)this.check(record2);
        ((ConsistencyReport.SchemaConsistencyReport)Mockito.verify((Object)report)).duplicateRuleContent(record1);
    }

    private DynamicRecord dynamicRecord(long id) {
        DynamicRecord record = new DynamicRecord(id);
        record.setType(255);
        return record;
    }
}

