/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.concurrent.ThreadLocalRandom;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.consistency.checking.full.QueueDistribution;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class QueueDistributionTest {
    private static final int MAX_NUMBER_OF_THREADS = 1000000;
    private static final int NUMBER_OF_DISTRIBUTION_ITERATIONS = 1000;

    @Test
    public void roundRobinRecordDistribution() throws Exception {
        this.testRecordDistribution(QueueDistribution.ROUND_ROBIN);
    }

    @Test
    public void relationshipNodesDistribution() throws InterruptedException {
        this.testRecordDistribution(QueueDistribution.RELATIONSHIPS);
    }

    private void testRecordDistribution(QueueDistribution queueDistribution) throws InterruptedException {
        ThreadLocalRandom randomGenerator = ThreadLocalRandom.current();
        int numberOfThreads = randomGenerator.nextInt(1000000);
        int recordsPerCpu = randomGenerator.nextInt(Integer.MAX_VALUE);
        QueueDistribution.QueueDistributor distributor = queueDistribution.distributor((long)recordsPerCpu, numberOfThreads);
        for (int iteration = 0; iteration <= 1000; ++iteration) {
            RelationshipRecord relationshipRecord = new RelationshipRecord(1L);
            relationshipRecord.setFirstNode(this.nextLong(randomGenerator));
            relationshipRecord.setSecondNode(this.nextLong(randomGenerator));
            distributor.distribute((Object)relationshipRecord, (record, qIndex) -> Assert.assertThat((String)("Distribution index for record " + record + " should be within a range of available executors, while expected records per cpu is: " + recordsPerCpu), (Object)qIndex, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(numberOfThreads)))));
        }
    }

    private long nextLong(ThreadLocalRandom randomGenerator) {
        return randomGenerator.nextLong();
    }
}

