/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.NodeDynamicLabelOrphanChainStartCheck;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

class NodeDynamicLabelOrphanChainStartCheckTest
extends RecordCheckTestBase<DynamicRecord, ConsistencyReport.DynamicLabelConsistencyReport, NodeDynamicLabelOrphanChainStartCheck> {
    NodeDynamicLabelOrphanChainStartCheckTest() {
        super(new NodeDynamicLabelOrphanChainStartCheck(), ConsistencyReport.DynamicLabelConsistencyReport.class, new int[0], new MultiPassStore[0]);
    }

    @Test
    void shouldReportMissingOwnerId() {
        DynamicRecord record = new DynamicRecord(0L);
        NodeDynamicLabelOrphanChainStartCheckTest.inUse(record);
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)new long[0], (DynamicRecordAllocator)new ReusableRecordsAllocator(66, new DynamicRecord[]{record}));
        ConsistencyReport.DynamicLabelConsistencyReport report = (ConsistencyReport.DynamicLabelConsistencyReport)this.check(record);
        ((ConsistencyReport.DynamicLabelConsistencyReport)Mockito.verify((Object)report)).orphanDynamicLabelRecord();
    }

    @Test
    void shouldReportOwningNodeRecordNotInUse() {
        NodeRecord nodeRecord = NodeDynamicLabelOrphanChainStartCheckTest.notInUse(new NodeRecord(12L, false, -1L, -1L));
        this.add(nodeRecord);
        DynamicRecord nodeDynamicLabelRecord = NodeDynamicLabelOrphanChainStartCheckTest.inUse(new DynamicRecord(0L));
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)new long[]{12L}, (DynamicRecordAllocator)new ReusableRecordsAllocator(66, new DynamicRecord[]{nodeDynamicLabelRecord}));
        ConsistencyReport.DynamicLabelConsistencyReport report = (ConsistencyReport.DynamicLabelConsistencyReport)this.check(nodeDynamicLabelRecord);
        ((ConsistencyReport.DynamicLabelConsistencyReport)Mockito.verify((Object)report)).orphanDynamicLabelRecordDueToInvalidOwner(nodeRecord);
    }

    @Test
    void shouldReportOwningNodeRecordNotPointingBack() {
        long nodeId = 12L;
        ArrayList validLabelRecords = new ArrayList();
        DynamicRecord dynamicRecord = NodeDynamicLabelOrphanChainStartCheckTest.inUse(new DynamicRecord(0L));
        DynamicArrayStore.allocateFromNumbers(validLabelRecords, (Object)new long[]{nodeId}, (DynamicRecordAllocator)new ReusableRecordsAllocator(66, new DynamicRecord[]{dynamicRecord}));
        ArrayList fakePointedToRecords = new ArrayList();
        DynamicRecord dynamicRecord1 = NodeDynamicLabelOrphanChainStartCheckTest.inUse(new DynamicRecord(1L));
        DynamicArrayStore.allocateFromNumbers(fakePointedToRecords, (Object)new long[]{nodeId}, (DynamicRecordAllocator)new ReusableRecordsAllocator(66, new DynamicRecord[]{dynamicRecord1}));
        NodeRecord nodeRecord = NodeDynamicLabelOrphanChainStartCheckTest.inUse(new NodeRecord(nodeId, false, -1L, -1L));
        nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(fakePointedToRecords), fakePointedToRecords);
        this.add(nodeRecord);
        ConsistencyReport.DynamicLabelConsistencyReport report = (ConsistencyReport.DynamicLabelConsistencyReport)this.check((AbstractBaseRecord)Iterators.single(validLabelRecords.iterator()));
        ((ConsistencyReport.DynamicLabelConsistencyReport)Mockito.verify((Object)report)).orphanDynamicLabelRecordDueToInvalidOwner(nodeRecord);
    }
}

