/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Suite;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={Nodes.class, Relationships.class, Properties.class, Strings.class, Arrays.class})
public abstract class MultiPassStoreTest {
    @Test
    public void shouldSkipOtherKindsOfRecords() {
        RecordAccess recordAccess = (RecordAccess)Mockito.mock(RecordAccess.class);
        List filters = this.multiPassStore().multiPassFilters(recordAccess, MultiPassStore.values());
        for (RecordAccess filter : filters) {
            for (long id : new long[]{0L, 100L, 200L, 300L, 400L, 500L, 600L, 700L, 800L, 900L}) {
                this.otherRecords(filter, id);
            }
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{recordAccess});
    }

    protected abstract MultiPassStore multiPassStore();

    protected abstract RecordReference<? extends AbstractBaseRecord> record(RecordAccess var1, long var2);

    protected abstract void otherRecords(RecordAccess var1, long var2);

    @RunWith(value=JUnit4.class)
    public static class Arrays
    extends MultiPassStoreTest {
        @Override
        protected MultiPassStore multiPassStore() {
            return MultiPassStore.ARRAYS;
        }

        protected RecordReference<DynamicRecord> record(RecordAccess filter, long id) {
            return filter.array(id);
        }

        @Override
        protected void otherRecords(RecordAccess filter, long id) {
            filter.node(id);
            filter.relationship(id);
            filter.property(id);
            filter.string(id);
        }
    }

    @RunWith(value=JUnit4.class)
    public static class Strings
    extends MultiPassStoreTest {
        @Override
        protected MultiPassStore multiPassStore() {
            return MultiPassStore.STRINGS;
        }

        protected RecordReference<DynamicRecord> record(RecordAccess filter, long id) {
            return filter.string(id);
        }

        @Override
        protected void otherRecords(RecordAccess filter, long id) {
            filter.node(id);
            filter.relationship(id);
            filter.property(id);
            filter.array(id);
        }
    }

    @RunWith(value=JUnit4.class)
    public static class Properties
    extends MultiPassStoreTest {
        @Override
        protected MultiPassStore multiPassStore() {
            return MultiPassStore.PROPERTIES;
        }

        protected RecordReference<PropertyRecord> record(RecordAccess filter, long id) {
            return filter.property(id);
        }

        @Override
        protected void otherRecords(RecordAccess filter, long id) {
            filter.node(id);
            filter.relationship(id);
            filter.string(id);
            filter.array(id);
        }
    }

    @RunWith(value=JUnit4.class)
    public static class Relationships
    extends MultiPassStoreTest {
        @Override
        protected MultiPassStore multiPassStore() {
            return MultiPassStore.RELATIONSHIPS;
        }

        protected RecordReference<RelationshipRecord> record(RecordAccess filter, long id) {
            return filter.relationship(id);
        }

        @Override
        protected void otherRecords(RecordAccess filter, long id) {
            filter.node(id);
            filter.property(id);
            filter.string(id);
            filter.array(id);
        }
    }

    @RunWith(value=JUnit4.class)
    public static class Nodes
    extends MultiPassStoreTest {
        @Override
        protected MultiPassStore multiPassStore() {
            return MultiPassStore.NODES;
        }

        protected RecordReference<NodeRecord> record(RecordAccess filter, long id) {
            return filter.node(id);
        }

        @Override
        protected void otherRecords(RecordAccess filter, long id) {
            filter.relationship(id);
            filter.property(id);
            filter.string(id);
            filter.array(id);
        }
    }
}

