/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.checking.full.RecordCheckWorker;
import org.neo4j.consistency.checking.full.RecordProcessor;
import org.neo4j.test.Race;

class RecordCheckWorkerTest {
    RecordCheckWorkerTest() {
    }

    @Test
    void shouldDoProcessingInitializationInOrder() throws Throwable {
        Race race = new Race();
        AtomicInteger coordination = new AtomicInteger(-1);
        final AtomicInteger expected = new AtomicInteger();
        int threads = 30;
        RecordCheckWorker[] workers = new RecordCheckWorker[30];
        RecordProcessor.Adapter<Integer> processor = new RecordProcessor.Adapter<Integer>(){

            public void process(Integer record) {
            }

            public void init(int id) {
                Assertions.assertEquals((int)id, (int)expected.getAndAdd(1));
            }
        };
        for (int id = 0; id < 30; ++id) {
            ArrayBlockingQueue queue = new ArrayBlockingQueue(10);
            workers[id] = new RecordCheckWorker(id, coordination, queue, (RecordProcessor)processor);
            race.addContestant((Runnable)workers[id]);
        }
        race.addContestant(() -> {
            try {
                long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(100L);
                while (System.currentTimeMillis() < end && expected.get() < 30) {
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
                }
                Assertions.assertEquals((int)30, (int)expected.get());
            }
            finally {
                for (RecordCheckWorker worker : workers) {
                    worker.done();
                }
            }
        });
        race.go();
    }
}

