/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.consistency.checking.ByteArrayBitsManipulator;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

@ExtendWith(value={RandomExtension.class})
class ByteArrayBitsManipulatorTest {
    @Inject
    protected RandomRule random;

    ByteArrayBitsManipulatorTest() {
    }

    @Test
    void shouldHandleMaxSlotSize() {
        ByteArrayBitsManipulator manipulator = new ByteArrayBitsManipulator(new int[]{40, 1});
        long[][] actual = new long[1000][];
        try (ByteArray array = NumberArrayFactory.HEAP.newByteArray((long)actual.length, new byte[11]);){
            int i;
            for (i = 0; i < actual.length; ++i) {
                actual[i] = new long[]{this.random.nextLong(0x10000000000L), this.random.nextBoolean() ? -1L : 0L};
                this.put(manipulator, array, i, actual[i]);
            }
            for (i = 0; i < actual.length; ++i) {
                this.verify(manipulator, array, i, actual[i]);
            }
        }
    }

    @Test
    void shouldHandleTwoMaxSlotsAndSomeBooleans() {
        ByteArrayBitsManipulator manipulator = new ByteArrayBitsManipulator(new int[]{40, 40, 1, 1, 1, 1});
        long[][] actual = new long[1000][];
        try (ByteArray array = NumberArrayFactory.HEAP.newByteArray((long)actual.length, new byte[11]);){
            int i;
            for (i = 0; i < actual.length; ++i) {
                actual[i] = new long[]{this.random.nextLong(0x10000000000L), this.random.nextLong(0x10000000000L), this.random.nextBoolean() ? -1L : 0L, this.random.nextBoolean() ? -1L : 0L, this.random.nextBoolean() ? -1L : 0L, this.random.nextBoolean() ? -1L : 0L};
                this.put(manipulator, array, i, actual[i]);
            }
            for (i = 0; i < actual.length; ++i) {
                this.verify(manipulator, array, i, actual[i]);
            }
        }
    }

    @Test
    void shouldHandleMinusOne() {
        ByteArrayBitsManipulator manipulator = new ByteArrayBitsManipulator(new int[]{40, 1});
        try (ByteArray array = NumberArrayFactory.HEAP.newByteArray(2L, new byte[11]);){
            this.put(manipulator, array, 0L, -1L, 0L);
            this.put(manipulator, array, 1L, -1L, -1L);
            this.verify(manipulator, array, 0L, -1L, 0L);
            this.verify(manipulator, array, 1L, -1L, -1L);
        }
    }

    private void verify(ByteArrayBitsManipulator manipulator, ByteArray array, long index, long ... values) {
        for (int i = 0; i < values.length; ++i) {
            Assertions.assertEquals((long)values[i], (long)manipulator.get(array, index, i));
        }
    }

    private void put(ByteArrayBitsManipulator manipulator, ByteArray array, long index, long ... values) {
        for (int i = 0; i < values.length; ++i) {
            manipulator.set(array, index, i, values[i]);
        }
    }
}

