/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.RelationshipTypeTokenRecordCheck;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

class RelationshipTypeTokenRecordCheckTest
extends RecordCheckTestBase<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport, RelationshipTypeTokenRecordCheck> {
    RelationshipTypeTokenRecordCheckTest() {
        super(new RelationshipTypeTokenRecordCheck(), ConsistencyReport.RelationshipTypeConsistencyReport.class, new int[0], new MultiPassStore[0]);
    }

    @Test
    void shouldNotReportAnythingForRecordNotInUse() {
        RelationshipTypeTokenRecord label = RelationshipTypeTokenRecordCheckTest.notInUse(new RelationshipTypeTokenRecord(42));
        ConsistencyReport.RelationshipTypeConsistencyReport report = (ConsistencyReport.RelationshipTypeConsistencyReport)this.check(label);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldNotReportAnythingForRecordThatDoesNotReferenceADynamicBlock() {
        RelationshipTypeTokenRecord label = RelationshipTypeTokenRecordCheckTest.inUse(new RelationshipTypeTokenRecord(42));
        ConsistencyReport.RelationshipTypeConsistencyReport report = (ConsistencyReport.RelationshipTypeConsistencyReport)this.check(label);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportDynamicBlockNotInUse() {
        RelationshipTypeTokenRecord label = RelationshipTypeTokenRecordCheckTest.inUse(new RelationshipTypeTokenRecord(42));
        DynamicRecord name = this.addRelationshipTypeName(RelationshipTypeTokenRecordCheckTest.notInUse(new DynamicRecord(6L)));
        label.setNameId((int)name.getId());
        ConsistencyReport.RelationshipTypeConsistencyReport report = (ConsistencyReport.RelationshipTypeConsistencyReport)this.check(label);
        ((ConsistencyReport.RelationshipTypeConsistencyReport)Mockito.verify((Object)report)).nameBlockNotInUse(name);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }

    @Test
    void shouldReportEmptyName() {
        RelationshipTypeTokenRecord label = RelationshipTypeTokenRecordCheckTest.inUse(new RelationshipTypeTokenRecord(42));
        DynamicRecord name = this.addRelationshipTypeName(RelationshipTypeTokenRecordCheckTest.inUse(new DynamicRecord(6L)));
        label.setNameId((int)name.getId());
        ConsistencyReport.RelationshipTypeConsistencyReport report = (ConsistencyReport.RelationshipTypeConsistencyReport)this.check(label);
        ((ConsistencyReport.RelationshipTypeConsistencyReport)Mockito.verify((Object)report)).emptyName(name);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{report});
    }
}

