/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.consistency.checking.full.GapFreeAllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.NodeLabelRange;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class GapFreeAllEntriesLabelScanReaderTest {
    private static final int EMPTY_RANGE = 0;
    private static final int NON_EMPTY_RANGE = 21;
    private static final int RANGE_SIZE = 10;
    private static final long[] LABEL_IDS = new long[]{1L};
    @Inject
    private RandomRule random;

    GapFreeAllEntriesLabelScanReaderTest() {
    }

    @Test
    void shouldFillGapInBeginning() {
        int[] ranges = GapFreeAllEntriesLabelScanReaderTest.array(0, 0, 21);
        GapFreeAllEntriesLabelScanReader reader = GapFreeAllEntriesLabelScanReaderTest.newGapFreeAllEntriesLabelScanReader(ranges);
        Iterator iterator = reader.iterator();
        GapFreeAllEntriesLabelScanReaderTest.assertRanges(iterator, ranges);
    }

    @Test
    void shouldFillGapInEnd() {
        int[] ranges = GapFreeAllEntriesLabelScanReaderTest.array(21, 0, 0);
        GapFreeAllEntriesLabelScanReader reader = GapFreeAllEntriesLabelScanReaderTest.newGapFreeAllEntriesLabelScanReader(ranges);
        Iterator iterator = reader.iterator();
        GapFreeAllEntriesLabelScanReaderTest.assertRanges(iterator, ranges);
    }

    @Test
    void shouldFillGapInMiddle() {
        int[] ranges = GapFreeAllEntriesLabelScanReaderTest.array(0, 21, 0);
        GapFreeAllEntriesLabelScanReader reader = GapFreeAllEntriesLabelScanReaderTest.newGapFreeAllEntriesLabelScanReader(ranges);
        Iterator iterator = reader.iterator();
        GapFreeAllEntriesLabelScanReaderTest.assertRanges(iterator, ranges);
    }

    @Test
    void shouldFillRandomGaps() {
        int numberOfRanges = this.random.intBetween(50, 100);
        int[] ranges = new int[numberOfRanges];
        for (int rangeId = 0; rangeId < numberOfRanges; ++rangeId) {
            ranges[rangeId] = this.random.nextInt(1024);
        }
        GapFreeAllEntriesLabelScanReader reader = GapFreeAllEntriesLabelScanReaderTest.newGapFreeAllEntriesLabelScanReader(ranges);
        Iterator iterator = reader.iterator();
        GapFreeAllEntriesLabelScanReaderTest.assertRanges(iterator, ranges);
    }

    private static void assertRanges(Iterator<NodeLabelRange> iterator, int[] expectedRanges) {
        for (int expectedRangeId = 0; expectedRangeId < expectedRanges.length; ++expectedRangeId) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            NodeLabelRange actualRange = iterator.next();
            Assertions.assertEquals((long)expectedRangeId, (long)actualRange.id());
            int expectedRange = expectedRanges[expectedRangeId];
            long baseNodeId = expectedRangeId * 10;
            for (int i = 0; i < 10; ++i) {
                long nodeId = baseNodeId + (long)i;
                long[] expectedLabelIds = (expectedRange & 1 << i) == 0 ? PrimitiveLongCollections.EMPTY_LONG_ARRAY : LABEL_IDS;
                Assertions.assertArrayEquals((long[])expectedLabelIds, (long[])actualRange.labels(nodeId));
                Assertions.assertEquals((long)nodeId, (long)actualRange.nodes()[i]);
            }
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    private static GapFreeAllEntriesLabelScanReader newGapFreeAllEntriesLabelScanReader(int ... ranges) {
        return new GapFreeAllEntriesLabelScanReader(GapFreeAllEntriesLabelScanReaderTest.ranges(10, ranges), (long)(10 * ranges.length));
    }

    private static AllEntriesLabelScanReader ranges(final int rangeSize, final int ... ranges) {
        final ArrayList<NodeLabelRange> rangeList = new ArrayList<NodeLabelRange>();
        for (int rangeId = 0; rangeId < ranges.length; ++rangeId) {
            rangeList.add(new NodeLabelRange((long)rangeId, GapFreeAllEntriesLabelScanReaderTest.labelsPerNode(ranges[rangeId])));
        }
        return new AllEntriesLabelScanReader(){

            public void close() {
            }

            public Iterator<NodeLabelRange> iterator() {
                return rangeList.iterator();
            }

            public long maxCount() {
                return ranges.length * rangeSize;
            }

            public int rangeSize() {
                return 10;
            }
        };
    }

    private static long[][] labelsPerNode(int relativeNodeIds) {
        long[][] result = new long[10][];
        for (int i = 0; i < 10; ++i) {
            if ((relativeNodeIds & 1 << i) == 0) continue;
            result[i] = LABEL_IDS;
        }
        return result;
    }

    private static int[] array(int ... relativeNodeIds) {
        return relativeNodeIds;
    }
}

