/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.test.rule.NeoStoresRule;

public class PropertyReaderTest {
    @Rule
    public final NeoStoresRule storesRule = new NeoStoresRule(PropertyReaderTest.class, new StoreType[]{StoreType.NODE, StoreType.COUNTS, StoreType.PROPERTY, StoreType.PROPERTY_ARRAY, StoreType.PROPERTY_STRING});

    @Test
    public void shouldDetectAndAbortPropertyChainLoadingOnCircularReference() throws IOException {
        NeoStores neoStores = this.storesRule.builder().build();
        PropertyStore propertyStore = neoStores.getPropertyStore();
        PropertyRecord record = propertyStore.newRecord();
        record.setId(1L);
        record.initialize(true, -1L, 2L);
        propertyStore.updateRecord(record);
        record.setId(2L);
        record.initialize(true, 1L, 3L);
        propertyStore.updateRecord(record);
        record.setId(3L);
        record.initialize(true, 2L, 4L);
        propertyStore.updateRecord(record);
        record.setId(4L);
        record.initialize(true, 3L, 2L);
        propertyStore.updateRecord(record);
        PropertyReader reader = new PropertyReader(new StoreAccess(neoStores));
        try {
            reader.getPropertyRecordChain(1L);
            Assert.fail((String)"Should have detected circular reference");
        }
        catch (PropertyReader.CircularPropertyRecordChainException e) {
            Assert.assertEquals((long)4L, (long)e.propertyRecordClosingTheCircle().getId());
        }
    }
}

