/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.concurrent.ThreadLocalRandom;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.checking.full.QueueDistribution;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class QueueDistributionTest {
    private static final int MAX_NUMBER_OF_THREADS = 1000000;
    private static final int NUMBER_OF_DISTRIBUTION_ITERATIONS = 1000;

    QueueDistributionTest() {
    }

    @Test
    void roundRobinRecordDistribution() throws Exception {
        QueueDistributionTest.testRecordDistribution(QueueDistribution.ROUND_ROBIN);
    }

    @Test
    void relationshipNodesDistribution() throws InterruptedException {
        QueueDistributionTest.testRecordDistribution(QueueDistribution.RELATIONSHIPS);
    }

    private static void testRecordDistribution(QueueDistribution queueDistribution) throws InterruptedException {
        ThreadLocalRandom randomGenerator = ThreadLocalRandom.current();
        int numberOfThreads = randomGenerator.nextInt(1000000);
        int recordsPerCpu = randomGenerator.nextInt(Integer.MAX_VALUE);
        QueueDistribution.QueueDistributor distributor = queueDistribution.distributor((long)recordsPerCpu, numberOfThreads);
        for (int iteration = 0; iteration <= 1000; ++iteration) {
            RelationshipRecord relationshipRecord = new RelationshipRecord(1L);
            relationshipRecord.setFirstNode(QueueDistributionTest.nextLong(randomGenerator));
            relationshipRecord.setSecondNode(QueueDistributionTest.nextLong(randomGenerator));
            distributor.distribute((Object)relationshipRecord, (record, qIndex) -> MatcherAssert.assertThat((String)("Distribution index for record " + record + " should be within a range of available executors, while expected records per cpu is: " + recordsPerCpu), (Object)qIndex, (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(numberOfThreads)))));
        }
    }

    private static long nextLong(ThreadLocalRandom randomGenerator) {
        return randomGenerator.nextLong();
    }
}

