/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.consistency.checking.full.QueueDistribution;
import org.neo4j.consistency.checking.full.RecordDistributor;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class RecordDistributorTest {
    RecordDistributorTest() {
    }

    @Test
    void shouldDistributeRelationshipRecordsByNodeId() throws Exception {
        QueueDistribution.RelationshipNodesQueueDistributor distributor = new QueueDistribution.RelationshipNodesQueueDistributor(5L, 100);
        RecordDistributor.RecordConsumer consumer = (RecordDistributor.RecordConsumer)Mockito.mock(RecordDistributor.RecordConsumer.class);
        RelationshipRecord relationship = RecordDistributorTest.relationship(0L, 0L, 1L);
        distributor.distribute((Object)relationship, consumer);
        ((RecordDistributor.RecordConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)relationship, 0);
        relationship = RecordDistributorTest.relationship(1L, 0L, 7L);
        distributor.distribute((Object)relationship, consumer);
        ((RecordDistributor.RecordConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)relationship, 0);
        ((RecordDistributor.RecordConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)relationship, 1);
        relationship = RecordDistributorTest.relationship(3L, 26L, 11L);
        distributor.distribute((Object)relationship, consumer);
        ((RecordDistributor.RecordConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)relationship, 5);
        ((RecordDistributor.RecordConsumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept((Object)relationship, 2);
    }

    private static RelationshipRecord relationship(long id, long startNodeId, long endNodeId) {
        RelationshipRecord record = new RelationshipRecord(id);
        record.setInUse(true);
        record.setFirstNode(startNodeId);
        record.setSecondNode(endNodeId);
        return record;
    }
}

