/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.consistency.repair.OwningNodeRelationshipChain;
import org.neo4j.consistency.repair.RecordSet;
import org.neo4j.consistency.repair.RelationshipChainExplorer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RecordStoreUtil;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class OwningNodeRelationshipChainTest {
    OwningNodeRelationshipChainTest() {
    }

    @Test
    void shouldFindBothChainsThatTheRelationshipRecordShouldBelongTo() {
        long node1 = 101L;
        long node1Rel = 1001L;
        long node2 = 201L;
        long node2Rel = 2001L;
        long sharedRel = 1000L;
        int relType = 0;
        RecordSet node1RelChain = OwningNodeRelationshipChainTest.asSet((AbstractBaseRecord[])new RelationshipRecord[]{new RelationshipRecord(node1Rel, node1, node1 - 1L, relType), new RelationshipRecord(sharedRel, node1, node2, relType), new RelationshipRecord(node1Rel + 1L, node1 + 1L, node1, relType)});
        RecordSet node2RelChain = OwningNodeRelationshipChainTest.asSet((AbstractBaseRecord[])new RelationshipRecord[]{new RelationshipRecord(node2Rel, node2 - 1L, node2, relType), new RelationshipRecord(sharedRel, node1, node2, relType), new RelationshipRecord(node2Rel + 1L, node2, node2 + 1L, relType)});
        RecordStore recordStore = (RecordStore)Mockito.mock(RecordStore.class);
        Mockito.when((Object)recordStore.getRecord(ArgumentMatchers.eq((long)node1), (AbstractBaseRecord)ArgumentMatchers.any(NodeRecord.class), (RecordLoad)ArgumentMatchers.any(RecordLoad.class))).thenAnswer((Answer)new RecordStoreUtil.ReadNodeAnswer(false, node1Rel, (long)Record.NO_NEXT_PROPERTY.intValue()));
        Mockito.when((Object)recordStore.getRecord(ArgumentMatchers.eq((long)node2), (AbstractBaseRecord)ArgumentMatchers.any(NodeRecord.class), (RecordLoad)ArgumentMatchers.any(RecordLoad.class))).thenAnswer((Answer)new RecordStoreUtil.ReadNodeAnswer(false, node2Rel, (long)Record.NO_NEXT_PROPERTY.intValue()));
        Mockito.when((Object)recordStore.newRecord()).thenReturn((Object)new NodeRecord(-1L));
        RelationshipChainExplorer relationshipChainExplorer = (RelationshipChainExplorer)Mockito.mock(RelationshipChainExplorer.class);
        Mockito.when((Object)relationshipChainExplorer.followChainFromNode(node1, node1Rel)).thenReturn((Object)node1RelChain);
        Mockito.when((Object)relationshipChainExplorer.followChainFromNode(node2, node2Rel)).thenReturn((Object)node2RelChain);
        OwningNodeRelationshipChain owningChainFinder = new OwningNodeRelationshipChain(relationshipChainExplorer, recordStore);
        RecordSet recordsInChains = owningChainFinder.findRelationshipChainsThatThisRecordShouldBelongTo(new RelationshipRecord(sharedRel, node1, node2, relType));
        MatcherAssert.assertThat((Object)recordsInChains, OwningNodeRelationshipChainTest.containsAllRecords((RecordSet<RelationshipRecord>)node1RelChain));
        MatcherAssert.assertThat((Object)recordsInChains, OwningNodeRelationshipChainTest.containsAllRecords((RecordSet<RelationshipRecord>)node2RelChain));
    }

    private static Matcher<RecordSet<RelationshipRecord>> containsAllRecords(final RecordSet<RelationshipRecord> expectedSet) {
        return new TypeSafeMatcher<RecordSet<RelationshipRecord>>(){

            public boolean matchesSafely(RecordSet<RelationshipRecord> actualSet) {
                return actualSet.containsAll(expectedSet);
            }

            public void describeTo(Description description) {
                description.appendText("RecordSet containing ").appendValueList("[", ",", "]", (Iterable)expectedSet);
            }
        };
    }

    @SafeVarargs
    private static <R extends AbstractBaseRecord> RecordSet<R> asSet(R ... records) {
        RecordSet set = new RecordSet();
        for (R record : records) {
            set.add(record);
        }
        return set;
    }
}

