/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.ConsistencyCheckMemoryCalculation;

class ConsistencyCheckMemoryCalculationTest {
    ConsistencyCheckMemoryCalculationTest() {
    }

    @Test
    void shouldKeepPageCacheMemoryIfEnoughMaxMemory() {
        int desiredPageCacheMemory = 1000;
        int desiredOffHeapCachingMemory = 100;
        ConsistencyCheckMemoryCalculation.MemoryDistribution distribution = ConsistencyCheckMemoryCalculation.calculate((long)10000L, (long)desiredPageCacheMemory, (long)desiredOffHeapCachingMemory);
        Assertions.assertThat((long)distribution.pageCacheMemory()).isEqualTo((long)desiredPageCacheMemory);
        Assertions.assertThat((long)distribution.offHeapCachingMemory()).isGreaterThanOrEqualTo((long)desiredOffHeapCachingMemory);
    }

    @Test
    void shouldConstrainPageCacheBarelyAboveLimit() {
        int desiredPageCacheMemory = 1000;
        int desiredOffHeapCachingMemory = 100;
        int maxOffHeapMemory = 900;
        ConsistencyCheckMemoryCalculation.MemoryDistribution distribution = ConsistencyCheckMemoryCalculation.calculate((long)maxOffHeapMemory, (long)desiredPageCacheMemory, (long)desiredOffHeapCachingMemory);
        Assertions.assertThat((long)distribution.pageCacheMemory()).isEqualTo((long)(maxOffHeapMemory - desiredOffHeapCachingMemory));
        Assertions.assertThat((long)distribution.offHeapCachingMemory()).isEqualTo((long)desiredOffHeapCachingMemory);
    }

    @Test
    void shouldConstrainPageCacheMoreOnWayAboveLimit() {
        int desiredPageCacheMemory = 1000;
        int desiredOffHeapCachingMemory = 100;
        int maxOffHeapMemory = 150;
        ConsistencyCheckMemoryCalculation.MemoryDistribution distribution = ConsistencyCheckMemoryCalculation.calculate((long)maxOffHeapMemory, (long)desiredPageCacheMemory, (long)desiredOffHeapCachingMemory);
        Assertions.assertThat((long)distribution.pageCacheMemory()).isLessThan((long)desiredPageCacheMemory);
        Assertions.assertThat((long)distribution.offHeapCachingMemory()).isLessThan((long)desiredOffHeapCachingMemory);
    }
}

