/*
 * Copyright (c) 2002-2016 "Neo Technology,"
 * Network Engine for Objects in Lund AB [http://neotechnology.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.coreedge.discovery;

import java.util.Collections;
import java.util.Set;

import org.neo4j.coreedge.server.AdvertisedSocketAddress;
import org.neo4j.coreedge.server.CoreMember;

public interface ClusterTopology
{
    ClusterTopology EMPTY = new ClusterTopology()
    {
        @Override
        public AdvertisedSocketAddress firstTransactionServer()
        {
            throw new RuntimeException( "No core server found" );
        }

        @Override
        public int getNumberOfCoreServers()
        {
            return 0;
        }

        @Override
        public Set<CoreMember> getMembers()
        {
            return Collections.<CoreMember>emptySet();
        }

        @Override
        public boolean bootstrappable()
        {
            return false;
        }
    };

    AdvertisedSocketAddress firstTransactionServer();

    int getNumberOfCoreServers();

    Set<CoreMember> getMembers();

    boolean bootstrappable();
}
