/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.SectionedCharBuffer;
import org.neo4j.csv.reader.ThreadAhead;

public class ThreadAheadReadable
extends ThreadAhead
implements CharReadable {
    private final CharReadable actual;
    private SectionedCharBuffer theOtherBuffer;
    private String sourceDescription;
    private String newSourceDescription;

    private ThreadAheadReadable(CharReadable actual, int bufferSize) {
        super(actual);
        this.actual = actual;
        this.theOtherBuffer = new SectionedCharBuffer(bufferSize);
        this.sourceDescription = actual.sourceDescription();
        this.start();
    }

    @Override
    public SectionedCharBuffer read(SectionedCharBuffer buffer, int from) throws IOException {
        this.waitUntilReadAhead();
        SectionedCharBuffer resultBuffer = this.theOtherBuffer;
        buffer.compact(resultBuffer, from);
        this.theOtherBuffer = buffer;
        if (this.newSourceDescription != null) {
            this.sourceDescription = this.newSourceDescription;
            this.newSourceDescription = null;
        }
        this.pokeReader();
        return resultBuffer;
    }

    @Override
    public int read(char[] into, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Unsupported for now");
    }

    @Override
    protected boolean readAhead() throws IOException {
        this.theOtherBuffer = this.actual.read(this.theOtherBuffer, this.theOtherBuffer.front());
        String sourceDescriptionAfterRead = this.actual.sourceDescription();
        if (!this.sourceDescription.equals(sourceDescriptionAfterRead)) {
            this.newSourceDescription = sourceDescriptionAfterRead;
        }
        return this.theOtherBuffer.hasAvailable();
    }

    @Override
    public long position() {
        return this.actual.position();
    }

    @Override
    public String sourceDescription() {
        return this.sourceDescription;
    }

    @Override
    public long lineNumber() {
        return 1L;
    }

    public static CharReadable threadAhead(CharReadable actual, int bufferSize) {
        return new ThreadAheadReadable(actual, bufferSize);
    }

    @Override
    public long length() {
        return this.actual.length();
    }
}

