/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2;

import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.ClosingIterator;
import org.neo4j.cypher.internal.compiler.v2_2.ClosingIteratorTest$;
import org.neo4j.cypher.internal.compiler.v2_2.CypherException;
import org.neo4j.cypher.internal.compiler.v2_2.TaskCloser;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u001f\t\u00192\t\\8tS:<\u0017\n^3sCR|'\u000fV3ti*\u00111\u0001B\u0001\u0005mJz&G\u0003\u0002\u0006\r\u0005A1m\\7qS2,'O\u0003\u0002\b\u0011\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\n\u0015\u000511-\u001f9iKJT!a\u0003\u0007\u0002\u000b9,w\u000e\u000e6\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0005M1\u0011aB2p[6|gn]\u0005\u0003+I\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!IA\u0004\u0001a\u0001\u0002\u0004%\t!H\u0001\u000bi\u0006\u001c8n\u00117pg\u0016\u0014X#\u0001\u0010\u0011\u0005iy\u0012B\u0001\u0011\u0003\u0005)!\u0016m]6DY>\u001cXM\u001d\u0005\nE\u0001\u0001\r\u00111A\u0005\u0002\r\na\u0002^1tW\u000ecwn]3s?\u0012*\u0017\u000f\u0006\u0002%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t!QK\\5u\u0011\u001dY\u0013%!AA\u0002y\t1\u0001\u001f\u00132\u0011\u0019i\u0003\u0001)Q\u0005=\u0005YA/Y:l\u00072|7/\u001a:!\u0011\u001dy\u0003A1A\u0005\u0002A\n!#\u001a=dKB$\u0018n\u001c8EK\u000e|'/\u0019;peV\t\u0011\u0007\u0005\u0003&eQ\"\u0014BA\u001a'\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\u001bk%\u0011aG\u0001\u0002\u0010\u0007f\u0004\b.\u001a:Fq\u000e,\u0007\u000f^5p]\"1\u0001\b\u0001Q\u0001\nE\n1#\u001a=dKB$\u0018n\u001c8EK\u000e|'/\u0019;pe\u0002BQA\u000f\u0001\u0005Bm\n!BY3g_J,W)Y2i)\u0005!\u0003")
public class ClosingIteratorTest
extends CypherFunSuite {
    private TaskCloser taskCloser;
    private final Function1<CypherException, CypherException> exceptionDecorator = new $anonfun$7(this);

    public TaskCloser taskCloser() {
        return this.taskCloser;
    }

    public void taskCloser_$eq(TaskCloser x$1) {
        this.taskCloser = x$1;
    }

    public Function1<CypherException, CypherException> exceptionDecorator() {
        return this.exceptionDecorator;
    }

    @Override
    public void beforeEach() {
        super.beforeEach();
        this.taskCloser_$eq((TaskCloser)this.mock(ManifestFactory$.MODULE$.classType(TaskCloser.class)));
    }

    public ClosingIteratorTest() {
        this.test("should_cleanup_when_we_reach_the_end", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)42))}))}));
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                Map result = iterator.next();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(true);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)42))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_cleanup_even_for_empty_iterator", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().empty();
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                boolean result = iterator.hasNext();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(true);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result)).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple_has_next_should_not_close_more_than_once", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().empty();
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                boolean result = iterator.hasNext();
                iterator.hasNext();
                iterator.hasNext();
                iterator.hasNext();
                iterator.hasNext();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser(), (VerificationMode)Mockito.atLeastOnce())).close(true);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result)).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("exception_in_hasNext_should_fail_transaction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = (Iterator)this.$outer.mock(ManifestFactory$.MODULE$.classType(Iterator.class, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)wrapee.hasNext())).thenThrow(new Throwable[]{new RuntimeException()});
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                this.$outer.intercept((Function0<Object>)new Serializable(this, iterator){
                    public static final long serialVersionUID = 0L;
                    private final ClosingIterator iterator$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.iterator$1.hasNext();
                    }
                    {
                        this.iterator$1 = iterator$1;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("exception_in_next_should_fail_transaction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = (Iterator)this.$outer.mock(ManifestFactory$.MODULE$.classType(Iterator.class, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
                Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)wrapee.hasNext())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                Mockito.when((Object)wrapee.next()).thenThrow(new Throwable[]{new RuntimeException()});
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                this.$outer.intercept((Function0<Object>)new Serializable(this, iterator){
                    public static final long serialVersionUID = 0L;
                    private final ClosingIterator iterator$2;

                    public final Map<String, Object> apply() {
                        return this.iterator$2.next();
                    }
                    {
                        this.iterator$2 = iterator$2;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("close_runs_cleanup", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClosingIteratorTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Iterator wrapee = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)42))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)43))}))}));
                ClosingIterator iterator = new ClosingIterator(wrapee, this.$outer.taskCloser(), this.$outer.exceptionDecorator());
                Map result = iterator.next();
                iterator.close();
                ((TaskCloser)Mockito.verify((Object)this.$outer.taskCloser())).close(true);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)42))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

