/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.DummyExpression;
import org.neo4j.cypher.internal.compiler.v2_2.DummyExpression$;
import org.neo4j.cypher.internal.compiler.v2_2.DummyPosition$;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.CollectionSlice;
import org.neo4j.cypher.internal.compiler.v2_2.ast.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.CypherType;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.package$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00192A!\u0001\u0002\u0001#\t\u00192i\u001c7mK\u000e$\u0018n\u001c8TY&\u001cW\rV3ti*\u00111\u0001B\u0001\u0004CN$(BA\u0003\u0007\u0003\u00111(g\u0018\u001a\u000b\u0005\u001dA\u0011\u0001C2p[BLG.\u001a:\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011Q\u0003C\u0001\bG>lWn\u001c8t\u0013\t9BC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0010IVlW._\"pY2,7\r^5p]V\t\u0001\u0005\u0005\u0002\"E5\tA!\u0003\u0002$\t\tyA)^7ns\u0016C\bO]3tg&|g\u000e\u0003\u0004&\u0001\u0001\u0006I\u0001I\u0001\u0011IVlW._\"pY2,7\r^5p]\u0002\u0002")
public class CollectionSliceTest
extends CypherFunSuite {
    private final DummyExpression dummyCollection = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()))), DummyExpression$.MODULE$.apply$default$2());

    public DummyExpression dummyCollection() {
        return this.dummyCollection;
    }

    public CollectionSliceTest() {
        this.test("shouldReturnCollectionTypesOfExpression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CollectionSliceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CollectionSlice slice = new CollectionSlice((Expression)this.$outer.dummyCollection(), (Option)new Some((Object)new SignedDecimalIntegerLiteral("1", DummyPosition$.MODULE$.apply(5))), (Option)new Some((Object)new SignedDecimalIntegerLiteral("2", DummyPosition$.MODULE$.apply(7))), DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)slice.semanticCheck((Expression.SemanticContext)Expression.SemanticContext$.Simple$.MODULE$).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(slice.types().apply((Object)result.state())).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldRaiseErrorWhenNeitherFromOrTwoSpecified", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CollectionSliceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CollectionSlice slice = new CollectionSlice((Expression)this.$outer.dummyCollection(), (Option)None$.MODULE$, (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)slice.semanticCheck((Expression.SemanticContext)Expression.SemanticContext$.Simple$.MODULE$).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("The start or end (or both) is required for a collection slice", slice.position(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldRaiseErrorIfStartingFromFraction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CollectionSliceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecimalDoubleLiteral to = new DecimalDoubleLiteral("1.3", DummyPosition$.MODULE$.apply(5));
                CollectionSlice slice = new CollectionSlice((Expression)this.$outer.dummyCollection(), (Option)None$.MODULE$, (Option)new Some((Object)to), DummyPosition$.MODULE$.apply(4));
                SemanticCheckResult result = (SemanticCheckResult)slice.semanticCheck((Expression.SemanticContext)Expression.SemanticContext$.Simple$.MODULE$).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("Type mismatch: expected Integer but was Float", to.position(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

