/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.DummyPosition$;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.DecimalDoubleLiteral;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E2A!\u0001\u0002\u0001#\tAB)Z2j[\u0006dGi\\;cY\u0016d\u0015\u000e^3sC2$Vm\u001d;\u000b\u0005\r!\u0011aA1ti*\u0011QAB\u0001\u0005mJz&G\u0003\u0002\b\u0011\u0005A1m\\7qS2,'O\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0005UA\u0011aB2p[6|gn]\u0005\u0003/Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!)a\u0004\u0001C\u0005?\u0005\u0019\u0012m]:feR\u001cV-\\1oi&\u001cWI\u001d:peR\u0019\u0001EJ\u0018\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006Ou\u0001\r\u0001K\u0001\fgR\u0014\u0018N\\4WC2,X\r\u0005\u0002*Y9\u0011\u0011EK\u0005\u0003W\t\na\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111F\t\u0005\u0006au\u0001\r\u0001K\u0001\rKJ\u0014xN]'fgN\fw-\u001a")
public class DecimalDoubleLiteralTest
extends CypherFunSuite {
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$DecimalDoubleLiteralTest$$assertSemanticError(String stringValue, String errorMessage) {
        DecimalDoubleLiteral literal = new DecimalDoubleLiteral(stringValue, DummyPosition$.MODULE$.apply(4));
        SemanticCheckResult result = (SemanticCheckResult)literal.semanticCheck((Expression.SemanticContext)Expression.SemanticContext$.Simple$.MODULE$).apply((Object)SemanticState$.MODULE$.clean());
        TripleEqualsSupport.Equalizer<Seq> $org_scalatest_assert_macro_left = this.convertToEqualizer(result.errors());
        Vector $org_scalatest_assert_macro_right = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError(errorMessage, DummyPosition$.MODULE$.apply(4), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public DecimalDoubleLiteralTest() {
        this.test("correctly parses decimal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalDoubleLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("22.34", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right = 22.34;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("-2342.34", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right2 = -2342.34;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("0.34", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right3 = 0.34;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("-.23", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right4 = -0.23;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("0.0", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right5 = 0.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("-0.0", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right6 = 0.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("1E23", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right7 = 1.0E23;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("-134E233", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right8 = -1.34E235;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("1E-99", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right9 = 1.0E-99;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("-4E-593", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right10 = -0.0;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("3.42E34", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right11 = 3.42E34;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("-65.342546547E33", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right12 = -6.5342546547E34;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("73.234E-235", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right13 = 7.3234E-234;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                TripleEqualsSupport.Equalizer<Double> $org_scalatest_assert_macro_left14 = this.$outer.convertToEqualizer(new DecimalDoubleLiteral("-73.234E-235", DummyPosition$.MODULE$.apply(0)).value());
                double $org_scalatest_assert_macro_right14 = -7.3234E-234;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid decimal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalDoubleLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$DecimalDoubleLiteralTest$$assertSemanticError("33..34", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$DecimalDoubleLiteralTest$$assertSemanticError("3f.34", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$DecimalDoubleLiteralTest$$assertSemanticError("3._4", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$DecimalDoubleLiteralTest$$assertSemanticError("2EE4", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$DecimalDoubleLiteralTest$$assertSemanticError("2E--4", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$DecimalDoubleLiteralTest$$assertSemanticError("2E", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$DecimalDoubleLiteralTest$$assertSemanticError("2..3E34", "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large decimal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecimalDoubleLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$DecimalDoubleLiteralTest$$assertSemanticError("1E9999", "floating point number is too large");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

