/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.ChainableSemanticCheck$;
import org.neo4j.cypher.internal.compiler.v2_2.DummyExpression;
import org.neo4j.cypher.internal.compiler.v2_2.DummyPosition$;
import org.neo4j.cypher.internal.compiler.v2_2.IdentityMap;
import org.neo4j.cypher.internal.compiler.v2_2.IdentityMap$;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Add;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.ExtractExpression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.ExtractExpression$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.FunctionInvocation;
import org.neo4j.cypher.internal.compiler.v2_2.ast.FunctionInvocation$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.FunctionName;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.ast.NodePattern;
import org.neo4j.cypher.internal.compiler.v2_2.ast.PatternElement;
import org.neo4j.cypher.internal.compiler.v2_2.ast.PatternExpression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.RelationshipChain;
import org.neo4j.cypher.internal.compiler.v2_2.ast.RelationshipPattern;
import org.neo4j.cypher.internal.compiler.v2_2.ast.RelationshipsPattern;
import org.neo4j.cypher.internal.compiler.v2_2.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Subtract;
import org.neo4j.cypher.internal.compiler.v2_2.package$;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.CypherType;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.TypeSpec;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.TypeSpec$;
import org.neo4j.graphdb.Direction;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.enablers.Size$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%2A!\u0001\u0002\u0001#\tqQ\t\u001f9sKN\u001c\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\r\t7\u000f\u001e\u0006\u0003\u000b\u0019\tAA\u001e\u001a`e)\u0011q\u0001C\u0001\tG>l\u0007/\u001b7fe*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0002\u0004\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0011\u000591m\\7n_:\u001c\u0018BA\f\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u00035\u0005\u001bHoQ8ogR\u0014Xo\u0019;j_:$Vm\u001d;TkB\u0004xN\u001d;\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002CA\r\u0001\u0011\u001d\t\u0003A1A\u0005\u0002\t\n!\"\u001a=qe\u0016\u001c8/[8o+\u0005\u0019\u0003C\u0001\u0013&\u001b\u0005!\u0011B\u0001\u0014\u0005\u0005=!U/\\7z\u000bb\u0004(/Z:tS>t\u0007B\u0002\u0015\u0001A\u0003%1%A\u0006fqB\u0014Xm]:j_:\u0004\u0003")
public class ExpressionTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final DummyExpression expression;
    private final InputPosition pos;

    @Override
    public InputPosition pos() {
        return this.pos;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    @Override
    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport$class.withPos(this, expr);
    }

    @Override
    public Identifier ident(String name) {
        return AstConstructionTestSupport$class.ident(this, name);
    }

    @Override
    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport$class.propEquality(this, identifier, propKey, intValue);
    }

    public DummyExpression expression() {
        return this.expression;
    }

    public ExpressionTest() {
        AstConstructionTestSupport$class.$init$(this);
        this.expression = new DummyExpression(org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.invariantTypeSpec((CypherType)org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTAny()), DummyPosition$.MODULE$.apply(0));
        this.test("shouldReturnCalculatedType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.expression().types().apply((Object)SemanticState$.MODULE$.clean())).should(this.$outer.equal(TypeSpec$.MODULE$.all()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldReturnTypeSetOfAllIfTypesRequestedButNotEvaluated", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.expression().types().apply((Object)SemanticState$.MODULE$.clean())).should(this.$outer.equal(TypeSpec$.MODULE$.all()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldReturnSpecifiedAndConstrainedTypes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticState state = ((SemanticCheckResult)ChainableSemanticCheck$.MODULE$.chain$extension(package$.MODULE$.chainableSemanticEitherFunc(this.$outer.expression().specifyType((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TypeSpec apply() {
                        return org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.invariantTypeSpec((CypherType)org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTNode()).$bar(org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.invariantTypeSpec((CypherType)org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTInteger()));
                    }
                })), this.$outer.expression().expectType((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TypeSpec apply() {
                        return org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTNumber().covariant();
                    }
                }, this.$outer.expression().expectType$default$2())).apply((Object)SemanticState$.MODULE$.clean())).state();
                this.$outer.convertToAnyShouldWrapper(this.$outer.expression().types().apply((Object)state)).should(this.$outer.equal(org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTInteger().invariant()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldRaiseTypeErrorWhenMismatchBetweenSpecifiedTypeAndExpectedType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticCheckResult result = (SemanticCheckResult)ChainableSemanticCheck$.MODULE$.chain$extension(package$.MODULE$.chainableSemanticEitherFunc(this.$outer.expression().specifyType((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TypeSpec apply() {
                        return org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.invariantTypeSpec((CypherType)org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTNode()).$bar(org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.invariantTypeSpec((CypherType)org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTInteger()));
                    }
                })), this.$outer.expression().expectType((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TypeSpec apply() {
                        return ((CypherType)org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTString()).covariant();
                    }
                }, this.$outer.expression().expectType$default$2())).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(((SemanticError)result.errors().head()).position()).should(this.$outer.equal(this.$outer.expression().position()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.expression().types().apply((Object)result.state())).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                this.$outer.convertToStringShouldWrapper(((SemanticError)result.errors().head()).msg()).should(this.$outer.equal("Type mismatch: expected String but was Integer or Node"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldRaiseTypeErrorWithCustomMessageWhenMismatchBetweenSpecifiedTypeAndExpectedType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticCheckResult result = (SemanticCheckResult)ChainableSemanticCheck$.MODULE$.chain$extension(package$.MODULE$.chainableSemanticEitherFunc(this.$outer.expression().specifyType((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TypeSpec apply() {
                        return org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.invariantTypeSpec((CypherType)org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTNode()).$bar(org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.invariantTypeSpec((CypherType)org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTInteger()));
                    }
                })), this.$outer.expression().expectType((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TypeSpec apply() {
                        return ((CypherType)org.neo4j.cypher.internal.compiler.v2_2.symbols.package$.MODULE$.CTString()).covariant();
                    }
                }, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String expected, String existing) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lhs was ", " yet rhs was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected, existing}));
                    }
                })).apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(((SemanticError)result.errors().head()).position()).should(this.$outer.equal(this.$outer.expression().position()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.expression().types().apply((Object)result.state())).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                TripleEqualsSupport.Equalizer<Integer> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)result.errors().size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer<InputPosition> $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(((SemanticError)result.errors().head()).position());
                InputPosition $org_scalatest_assert_macro_right2 = this.$outer.expression().position();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                String $org_scalatest_assert_macro_left3 = ((SemanticError)result.errors().head()).msg();
                String $org_scalatest_assert_macro_right3 = "Type mismatch: lhs was String yet rhs was Integer or Node";
                String string = $org_scalatest_assert_macro_left3;
                String string2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TypeSpec $org_scalatest_assert_macro_left4 = (TypeSpec)this.$outer.expression().types().apply((Object)result.state());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should compute dependencies of simple expressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.ident("a").dependencies()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{this.$outer.ident("a")}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(new SignedDecimalIntegerLiteral("1", this.$outer.pos()).dependencies()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should compute dependencies of composite expressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SignedDecimalIntegerLiteral signedDecimalIntegerLiteral = new SignedDecimalIntegerLiteral("1", this.$outer.pos());
                Identifier identifier = this.$outer.ident("b");
                this.$outer.convertToAnyShouldWrapper(new Add((Expression)this.$outer.ident("a"), (Expression)this.$outer.withPos(new Serializable(this, signedDecimalIntegerLiteral, identifier){
                    public static final long serialVersionUID = 0L;
                    private final SignedDecimalIntegerLiteral eta$0$1$1;
                    private final Identifier eta$1$1$1;

                    public final Subtract apply(InputPosition position) {
                        return new Subtract((Expression)this.eta$0$1$1, (Expression)this.eta$1$1$1, position);
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                        this.eta$1$1$1 = eta$1$1$1;
                    }
                }), this.$outer.pos()).dependencies()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{this.$outer.ident("a"), this.$outer.ident("b")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should compute dependencies for filtering expressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Some some = new Some((Object)this.$outer.ident("n"));
                Seq seq = (Seq)Seq$.MODULE$.empty();
                NodePattern nodePattern = (NodePattern)this.$outer.withPos(new Serializable(this, some, seq){
                    public static final long serialVersionUID = 0L;
                    private final Some eta$0$2$1;
                    private final Seq eta$1$2$1;

                    public final NodePattern apply(InputPosition position) {
                        return new NodePattern((Option)this.eta$0$2$1, this.eta$1$2$1, (Option)None$.MODULE$, false, position);
                    }
                    {
                        this.eta$0$2$1 = eta$0$2$1;
                        this.eta$1$2$1 = eta$1$2$1;
                    }
                });
                Seq seq2 = (Seq)Seq$.MODULE$.empty();
                RelationshipPattern relationshipPattern = (RelationshipPattern)this.$outer.withPos(new Serializable(this, seq2){
                    public static final long serialVersionUID = 0L;
                    private final Seq eta$0$3$1;

                    public final RelationshipPattern apply(InputPosition position) {
                        return new RelationshipPattern((Option)None$.MODULE$, false, this.eta$0$3$1, (Option)None$.MODULE$, (Option)None$.MODULE$, Direction.OUTGOING, position);
                    }
                    {
                        this.eta$0$3$1 = eta$0$3$1;
                    }
                });
                Some some2 = new Some((Object)this.$outer.ident("k"));
                Seq seq3 = (Seq)Seq$.MODULE$.empty();
                NodePattern nodePattern2 = (NodePattern)this.$outer.withPos(new Serializable(this, some2, seq3){
                    public static final long serialVersionUID = 0L;
                    private final Some eta$0$4$1;
                    private final Seq eta$1$3$1;

                    public final NodePattern apply(InputPosition position) {
                        return new NodePattern((Option)this.eta$0$4$1, this.eta$1$3$1, (Option)None$.MODULE$, false, position);
                    }
                    {
                        this.eta$0$4$1 = eta$0$4$1;
                        this.eta$1$3$1 = eta$1$3$1;
                    }
                });
                RelationshipChain relationshipChain = (RelationshipChain)this.$outer.withPos(new Serializable(this, nodePattern, relationshipPattern, nodePattern2){
                    public static final long serialVersionUID = 0L;
                    private final NodePattern eta$0$5$1;
                    private final RelationshipPattern eta$1$4$1;
                    private final NodePattern eta$2$1$1;

                    public final RelationshipChain apply(InputPosition position) {
                        return new RelationshipChain((PatternElement)this.eta$0$5$1, this.eta$1$4$1, this.eta$2$1$1, position);
                    }
                    {
                        this.eta$0$5$1 = eta$0$5$1;
                        this.eta$1$4$1 = eta$1$4$1;
                        this.eta$2$1$1 = eta$2$1$1;
                    }
                });
                RelationshipsPattern pat = (RelationshipsPattern)this.$outer.withPos(new Serializable(this, relationshipChain){
                    public static final long serialVersionUID = 0L;
                    private final RelationshipChain eta$0$6$1;

                    public final RelationshipsPattern apply(InputPosition position) {
                        return new RelationshipsPattern(this.eta$0$6$1, position);
                    }
                    {
                        this.eta$0$6$1 = eta$0$6$1;
                    }
                });
                Identifier identifier = this.$outer.ident("x");
                PatternExpression patternExpression = new PatternExpression(pat);
                FunctionName functionName = (FunctionName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FunctionName apply(InputPosition position) {
                        return new FunctionName("head", position);
                    }
                });
                FunctionName functionName2 = (FunctionName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FunctionName apply(InputPosition position) {
                        return new FunctionName("nodes", position);
                    }
                });
                Identifier identifier2 = this.$outer.ident("x");
                FunctionInvocation functionInvocation = (FunctionInvocation)this.$outer.withPos(new Serializable(this, functionName2, identifier2){
                    public static final long serialVersionUID = 0L;
                    private final FunctionName eta$0$7$1;
                    private final Identifier eta$1$5$1;

                    public final FunctionInvocation apply(InputPosition position) {
                        return FunctionInvocation$.MODULE$.apply(this.eta$0$7$1, (Expression)this.eta$1$5$1, position);
                    }
                    {
                        this.eta$0$7$1 = eta$0$7$1;
                        this.eta$1$5$1 = eta$1$5$1;
                    }
                });
                Some some3 = new Some(this.$outer.withPos(new Serializable(this, functionName, functionInvocation){
                    public static final long serialVersionUID = 0L;
                    private final FunctionName eta$0$8$1;
                    private final FunctionInvocation eta$1$6$1;

                    public final FunctionInvocation apply(InputPosition position) {
                        return FunctionInvocation$.MODULE$.apply(this.eta$0$8$1, (Expression)this.eta$1$6$1, position);
                    }
                    {
                        this.eta$0$8$1 = eta$0$8$1;
                        this.eta$1$6$1 = eta$1$6$1;
                    }
                }));
                Expression expr = (Expression)this.$outer.withPos(new Serializable(this, identifier, patternExpression, some3){
                    public static final long serialVersionUID = 0L;
                    private final Identifier eta$0$9$1;
                    private final PatternExpression eta$1$7$1;
                    private final Some eta$2$2$1;

                    public final ExtractExpression apply(InputPosition position) {
                        return ExtractExpression$.MODULE$.apply(this.eta$0$9$1, (Expression)this.eta$1$7$1, (Option)None$.MODULE$, (Option)this.eta$2$2$1, position);
                    }
                    {
                        this.eta$0$9$1 = eta$0$9$1;
                        this.eta$1$7$1 = eta$1$7$1;
                        this.eta$2$2$1 = eta$2$2$1;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(expr.dependencies()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{this.$outer.ident("n"), this.$outer.ident("k")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should compute inputs of composite expressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Identifier identA = this.$outer.ident("a");
                Identifier identB = this.$outer.ident("b");
                SignedDecimalIntegerLiteral lit1 = new SignedDecimalIntegerLiteral("1", this.$outer.pos());
                Subtract sub = new Subtract((Expression)lit1, (Expression)identB, this.$outer.pos());
                Add add = new Add((Expression)identA, (Expression)sub, this.$outer.pos());
                this.$outer.convertToAnyShouldWrapper(IdentityMap$.MODULE$.apply(add.inputs())).should(this.$outer.equal(IdentityMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)identA), (Object)Predef$.MODULE$.Set().empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)identB), (Object)Predef$.MODULE$.Set().empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)lit1), (Object)Predef$.MODULE$.Set().empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)sub), (Object)Predef$.MODULE$.Set().empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)add), (Object)Predef$.MODULE$.Set().empty())}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should compute inputs for filtering expressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Some some = new Some((Object)this.$outer.ident("n"));
                Seq seq = (Seq)Seq$.MODULE$.empty();
                NodePattern nodePattern = (NodePattern)this.$outer.withPos(new Serializable(this, some, seq){
                    public static final long serialVersionUID = 0L;
                    private final Some eta$0$10$1;
                    private final Seq eta$1$8$1;

                    public final NodePattern apply(InputPosition position) {
                        return new NodePattern((Option)this.eta$0$10$1, this.eta$1$8$1, (Option)None$.MODULE$, false, position);
                    }
                    {
                        this.eta$0$10$1 = eta$0$10$1;
                        this.eta$1$8$1 = eta$1$8$1;
                    }
                });
                Seq seq2 = (Seq)Seq$.MODULE$.empty();
                RelationshipPattern relationshipPattern = (RelationshipPattern)this.$outer.withPos(new Serializable(this, seq2){
                    public static final long serialVersionUID = 0L;
                    private final Seq eta$0$11$1;

                    public final RelationshipPattern apply(InputPosition position) {
                        return new RelationshipPattern((Option)None$.MODULE$, false, this.eta$0$11$1, (Option)None$.MODULE$, (Option)None$.MODULE$, Direction.OUTGOING, position);
                    }
                    {
                        this.eta$0$11$1 = eta$0$11$1;
                    }
                });
                Some some2 = new Some((Object)this.$outer.ident("k"));
                Seq seq3 = (Seq)Seq$.MODULE$.empty();
                NodePattern nodePattern2 = (NodePattern)this.$outer.withPos(new Serializable(this, some2, seq3){
                    public static final long serialVersionUID = 0L;
                    private final Some eta$0$12$1;
                    private final Seq eta$1$9$1;

                    public final NodePattern apply(InputPosition position) {
                        return new NodePattern((Option)this.eta$0$12$1, this.eta$1$9$1, (Option)None$.MODULE$, false, position);
                    }
                    {
                        this.eta$0$12$1 = eta$0$12$1;
                        this.eta$1$9$1 = eta$1$9$1;
                    }
                });
                RelationshipChain relationshipChain = (RelationshipChain)this.$outer.withPos(new Serializable(this, nodePattern, relationshipPattern, nodePattern2){
                    public static final long serialVersionUID = 0L;
                    private final NodePattern eta$0$13$1;
                    private final RelationshipPattern eta$1$10$1;
                    private final NodePattern eta$2$3$1;

                    public final RelationshipChain apply(InputPosition position) {
                        return new RelationshipChain((PatternElement)this.eta$0$13$1, this.eta$1$10$1, this.eta$2$3$1, position);
                    }
                    {
                        this.eta$0$13$1 = eta$0$13$1;
                        this.eta$1$10$1 = eta$1$10$1;
                        this.eta$2$3$1 = eta$2$3$1;
                    }
                });
                PatternExpression pat = new PatternExpression((RelationshipsPattern)this.$outer.withPos(new Serializable(this, relationshipChain){
                    public static final long serialVersionUID = 0L;
                    private final RelationshipChain eta$0$14$1;

                    public final RelationshipsPattern apply(InputPosition position) {
                        return new RelationshipsPattern(this.eta$0$14$1, position);
                    }
                    {
                        this.eta$0$14$1 = eta$0$14$1;
                    }
                }));
                FunctionName functionName = (FunctionName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FunctionName apply(InputPosition position) {
                        return new FunctionName("nodes", position);
                    }
                });
                Identifier identifier = this.$outer.ident("x");
                Expression callNodes = (Expression)this.$outer.withPos(new Serializable(this, functionName, identifier){
                    public static final long serialVersionUID = 0L;
                    private final FunctionName eta$0$15$1;
                    private final Identifier eta$1$11$1;

                    public final FunctionInvocation apply(InputPosition position) {
                        return FunctionInvocation$.MODULE$.apply(this.eta$0$15$1, (Expression)this.eta$1$11$1, position);
                    }
                    {
                        this.eta$0$15$1 = eta$0$15$1;
                        this.eta$1$11$1 = eta$1$11$1;
                    }
                });
                FunctionName functionName2 = (FunctionName)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FunctionName apply(InputPosition position) {
                        return new FunctionName("head", position);
                    }
                });
                Expression callHead = (Expression)this.$outer.withPos(new Serializable(this, callNodes, functionName2){
                    public static final long serialVersionUID = 0L;
                    private final Expression callNodes$1;
                    private final FunctionName eta$0$16$1;

                    public final FunctionInvocation apply(InputPosition position) {
                        return FunctionInvocation$.MODULE$.apply(this.eta$0$16$1, this.callNodes$1, position);
                    }
                    {
                        this.callNodes$1 = callNodes$1;
                        this.eta$0$16$1 = eta$0$16$1;
                    }
                });
                Identifier identifier2 = this.$outer.ident("x");
                Some some3 = new Some((Object)callHead);
                Expression expr = (Expression)this.$outer.withPos(new Serializable(this, pat, identifier2, some3){
                    public static final long serialVersionUID = 0L;
                    private final PatternExpression pat$1;
                    private final Identifier eta$0$17$1;
                    private final Some eta$1$12$1;

                    public final ExtractExpression apply(InputPosition position) {
                        return ExtractExpression$.MODULE$.apply(this.eta$0$17$1, (Expression)this.pat$1, (Option)None$.MODULE$, (Option)this.eta$1$12$1, position);
                    }
                    {
                        this.pat$1 = pat$1;
                        this.eta$0$17$1 = eta$0$17$1;
                        this.eta$1$12$1 = eta$1$12$1;
                    }
                });
                IdentityMap inputs = IdentityMap$.MODULE$.apply(expr.inputs());
                this.$outer.convertToAnyShouldWrapper(inputs.apply((Object)callNodes)).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{this.$outer.ident("x")}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(inputs.apply((Object)callHead)).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Identifier[]{this.$outer.ident("x")}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(inputs.apply((Object)expr)).should(this.$outer.equal(Predef$.MODULE$.Set().empty()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(inputs.apply((Object)pat)).should(this.$outer.equal(Predef$.MODULE$.Set().empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

