/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.DummyPosition$;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.SignedHexIntegerLiteral;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E2A!\u0001\u0002\u0001#\t)\u0002*\u001a=J]R,w-\u001a:MSR,'/\u00197UKN$(BA\u0002\u0005\u0003\r\t7\u000f\u001e\u0006\u0003\u000b\u0019\tAA\u001e\u001a`e)\u0011q\u0001C\u0001\tG>l\u0007/\u001b7fe*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"BA\u000b\t\u0003\u001d\u0019w.\\7p]NL!a\u0006\u000b\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u0001!IaH\u0001\u0014CN\u001cXM\u001d;TK6\fg\u000e^5d\u000bJ\u0014xN\u001d\u000b\u0004A\u0019z\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#\u0001B+oSRDQaJ\u000fA\u0002!\n1b\u001d;sS:<g+\u00197vKB\u0011\u0011\u0006\f\b\u0003C)J!a\u000b\u0012\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003W\tBQ\u0001M\u000fA\u0002!\nA\"\u001a:s_JlUm]:bO\u0016\u0004")
public class HexIntegerLiteralTest
extends CypherFunSuite {
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$HexIntegerLiteralTest$$assertSemanticError(String stringValue, String errorMessage) {
        SignedHexIntegerLiteral literal = new SignedHexIntegerLiteral(stringValue, DummyPosition$.MODULE$.apply(4));
        SemanticCheckResult result = (SemanticCheckResult)literal.semanticCheck((Expression.SemanticContext)Expression.SemanticContext$.Simple$.MODULE$).apply((Object)SemanticState$.MODULE$.clean());
        TripleEqualsSupport.Equalizer<Seq> $org_scalatest_assert_macro_left = this.convertToEqualizer(result.errors());
        Vector $org_scalatest_assert_macro_right = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError(errorMessage, DummyPosition$.MODULE$.apply(4), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public HexIntegerLiteralTest() {
        this.test("correctly parses hexadecimal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HexIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer<Long> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("0x22", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right = 34;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer<Long> $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("0x0", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer<Long> $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("0xffFF", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right3 = 65535;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer<Long> $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(new SignedHexIntegerLiteral("-0x9abc", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right4 = -39612;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid hexadecimal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HexIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$HexIntegerLiteralTest$$assertSemanticError("0x12g3", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$HexIntegerLiteralTest$$assertSemanticError("0x", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$HexIntegerLiteralTest$$assertSemanticError("0x33Y23", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$HexIntegerLiteralTest$$assertSemanticError("-0x12g3", "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large hexadecimal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HexIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$HexIntegerLiteralTest$$assertSemanticError("0xfffffffffffffffff", "integer is too large");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

