/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.DummyExpression;
import org.neo4j.cypher.internal.compiler.v2_2.DummyExpression$;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression$;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.TypeSpec;
import org.scalactic.Equality$;
import org.scalatest.enablers.Emptiness$;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0001\u0002\u0002\u0002E\u0011q#\u00138gSb,\u0005\u0010\u001d:fgNLwN\u001c+fgR\u0014\u0015m]3\u000b\u0005\r!\u0011aA1ti*\u0011QAB\u0001\u0005mJz&G\u0003\u0002\b\u0011\u0005A1m\\7qS2,'O\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0005UA\u0011aB2p[6|gn]\u0005\u0003/Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\r\u0019GO\u001d\t\u00067y\u0001\u0003\u0005I\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\tIa)\u001e8di&|gN\r\t\u0003C\tj\u0011AA\u0005\u0003G\t\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\u0011q\u0005\u000b\t\u0003C\u0001AQ!\u0007\u0013A\u0002iAqA\u000b\u0001C\u0002\u0013E1&A\u0004d_:$X\r\u001f;\u0016\u00031\u0002\"!L!\u000f\u00059zdBA\u0018?\u001d\t\u0001TH\u0004\u00022y9\u0011!g\u000f\b\u0003gir!\u0001N\u001d\u000f\u0005UBT\"\u0001\u001c\u000b\u0005]\u0002\u0012A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tia\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011B\u0001!\u0003\u0003))\u0005\u0010\u001d:fgNLwN\\\u0005\u0003\u0005\u000e\u0013qbU3nC:$\u0018nY\"p]R,\u0007\u0010\u001e\u0006\u0003\u0001\nAa!\u0012\u0001!\u0002\u0013a\u0013\u0001C2p]R,\u0007\u0010\u001e\u0011\t\u000b\u001d\u0003A\u0011\u0003%\u0002\u001dQ,7\u000f\u001e,bY&$G+\u001f9fgR\u0019\u0011*V,\u0015\u0005)k\u0005CA\u000eL\u0013\taED\u0001\u0003V]&$\b\"\u0002(G\u0001\u0004y\u0015\u0001C3ya\u0016\u001cG/\u001a3\u0011\u0005A\u001bV\"A)\u000b\u0005I#\u0011aB:z[\n|Gn]\u0005\u0003)F\u0013\u0001\u0002V=qKN\u0003Xm\u0019\u0005\u0006-\u001a\u0003\raT\u0001\tY\"\u001cH+\u001f9fg\")\u0001L\u0012a\u0001\u001f\u0006A!\u000f[:UsB,7\u000fC\u0003[\u0001\u0011E1,\u0001\fuKN$\u0018J\u001c<bY&$\u0017\t\u001d9mS\u000e\fG/[8o)\rafm\u001a\u000b\u0003\u0015vCQAX-A\u0002}\u000bq!\\3tg\u0006<W\r\u0005\u0002aG:\u00111$Y\u0005\u0003Er\ta\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\u0019\u0019FO]5oO*\u0011!\r\b\u0005\u0006-f\u0003\ra\u0014\u0005\u00061f\u0003\ra\u0014\u0005\u0006S\u0002!\tB[\u0001\u0012KZ\fG.^1uK^KG\u000f\u001b+za\u0016\u001cHcA6sgB!1\u0004\u001c8!\u0013\tiGD\u0001\u0004UkBdWM\r\t\u0003_Bl\u0011\u0001B\u0005\u0003c\u0012\u00111cU3nC:$\u0018nY\"iK\u000e\\'+Z:vYRDQA\u00165A\u0002=CQ\u0001\u00175A\u0002=\u0003")
public abstract class InfixExpressionTestBase
extends CypherFunSuite {
    private final Function2<Expression, Expression, Expression> ctr;
    private final Expression.SemanticContext context;

    public Expression.SemanticContext context() {
        return this.context;
    }

    public void testValidTypes(TypeSpec lhsTypes, TypeSpec rhsTypes, TypeSpec expected) {
        Tuple2<SemanticCheckResult, Expression> tuple2 = this.evaluateWithTypes(lhsTypes, rhsTypes);
        if (tuple2 != null) {
            Tuple2 tuple22;
            SemanticCheckResult result = (SemanticCheckResult)tuple2._1();
            Expression expression = (Expression)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)result, (Object)expression);
            SemanticCheckResult result2 = (SemanticCheckResult)tuple23._1();
            Expression expression2 = (Expression)tuple23._2();
            this.convertToAnyShouldWrapper(result2.errors()).shouldBe(this.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            this.convertToAnyShouldWrapper(expression2.types().apply((Object)result2.state())).should(this.equal(expected), (Object)Equality$.MODULE$.default());
            return;
        }
        throw new MatchError(tuple2);
    }

    public void testInvalidApplication(TypeSpec lhsTypes, TypeSpec rhsTypes, String message) {
        Tuple2<SemanticCheckResult, Expression> tuple2 = this.evaluateWithTypes(lhsTypes, rhsTypes);
        if (tuple2 != null) {
            SemanticCheckResult result;
            SemanticCheckResult semanticCheckResult;
            SemanticCheckResult result2 = semanticCheckResult = (result = (SemanticCheckResult)tuple2._1());
            this.convertToAnyShouldWrapper(result2.errors()).should(this.not()).be(this.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            this.convertToStringShouldWrapper(((SemanticError)result2.errors().head()).msg()).should(this.equal(message), (Object)Equality$.MODULE$.default());
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<SemanticCheckResult, Expression> evaluateWithTypes(TypeSpec lhsTypes, TypeSpec rhsTypes) {
        DummyExpression lhs = new DummyExpression(lhsTypes, DummyExpression$.MODULE$.apply$default$2());
        DummyExpression rhs = new DummyExpression(rhsTypes, DummyExpression$.MODULE$.apply$default$2());
        Expression expression = (Expression)this.ctr.apply((Object)lhs, (Object)rhs);
        SemanticState state = ((SemanticCheckResult)Expression$.MODULE$.SemanticCheckableExpressionTraversable((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DummyExpression[]{lhs, rhs}))).semanticCheck(this.context()).apply((Object)SemanticState$.MODULE$.clean())).state();
        return new Tuple2(expression.semanticCheck(this.context()).apply((Object)state), (Object)expression);
    }

    public InfixExpressionTestBase(Function2<Expression, Expression, Expression> ctr) {
        this.ctr = ctr;
        this.context = Expression.SemanticContext$.Simple$.MODULE$;
    }
}

