/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.DummyPosition$;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.ast.LoadCSV;
import org.neo4j.cypher.internal.compiler.v2_2.ast.StringLiteral;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.CypherType;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.TypeSpec;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.package$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001#\tYAj\\1e\u0007N3F+Z:u\u0015\t\u0019A!A\u0002bgRT!!\u0002\u0004\u0002\tY\u0014tL\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)\u0002\"A\u0004d_6lwN\\:\n\u0005]!\"AD\"za\",'OR;o'VLG/\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u0013\u0005q$\u0001\u0006mSR,'/\u00197V%2+\u0012\u0001\t\t\u00039\u0005J!A\t\u0002\u0003\u001bM#(/\u001b8h\u0019&$XM]1m\u0011\u0019!\u0003\u0001)A\u0005A\u0005YA.\u001b;fe\u0006dWK\u0015'!\u0011\u001d1\u0003A1A\u0005\u0002\u001d\n!\"\u001b3f]RLg-[3s+\u0005A\u0003C\u0001\u000f*\u0013\tQ#A\u0001\u0006JI\u0016tG/\u001b4jKJDa\u0001\f\u0001!\u0002\u0013A\u0013aC5eK:$\u0018NZ5fe\u0002\u0002")
public class LoadCSVTest
extends CypherFunSuite {
    private final StringLiteral literalURL = new StringLiteral("file:///tmp/foo.csv", DummyPosition$.MODULE$.apply(4));
    private final Identifier identifier = new Identifier("a", DummyPosition$.MODULE$.apply(4));

    public StringLiteral literalURL() {
        return this.literalURL;
    }

    public Identifier identifier() {
        return this.identifier;
    }

    public LoadCSVTest() {
        this.test("cannot overwrite existing identifier", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LoadCSV loadCSV = new LoadCSV(true, (Expression)this.$outer.literalURL(), this.$outer.identifier(), (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer<Seq> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.errors());
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("when expecting headers, the identifier has a map type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LoadCSV loadCSV = new LoadCSV(true, (Expression)this.$outer.literalURL(), this.$outer.identifier(), (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TypeSpec expressionType = result.state().expressionType((Expression)this.$outer.identifier()).actual();
                TripleEqualsSupport.Equalizer<TypeSpec> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(expressionType);
                TypeSpec $org_scalatest_assert_macro_right = package$.MODULE$.CTMap().invariant();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("when not expecting headers, the identifier has a collection type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LoadCSV loadCSV = new LoadCSV(false, (Expression)this.$outer.literalURL(), this.$outer.identifier(), (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TypeSpec expressionType = result.state().expressionType((Expression)this.$outer.identifier()).actual();
                TripleEqualsSupport.Equalizer<TypeSpec> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(expressionType);
                TypeSpec $org_scalatest_assert_macro_right = package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()).invariant();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should accept one-character wide field terminators", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral literal = new StringLiteral("http://example.com/foo.csv", DummyPosition$.MODULE$.apply(4));
                LoadCSV loadCSV = new LoadCSV(false, (Expression)literal, this.$outer.identifier(), (Option)new Some((Object)new StringLiteral("\t", DummyPosition$.MODULE$.apply(0))), DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer<Seq> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.errors());
                Vector $org_scalatest_assert_macro_right = scala.package$.MODULE$.Vector().empty();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should reject more-than-one-character wide field terminators", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral literal = new StringLiteral("http://example.com/foo.csv", DummyPosition$.MODULE$.apply(4));
                LoadCSV loadCSV = new LoadCSV(false, (Expression)literal, this.$outer.identifier(), (Option)new Some((Object)new StringLiteral("  ", DummyPosition$.MODULE$.apply(0))), DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer<Seq> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.errors());
                Vector $org_scalatest_assert_macro_right = (Vector)scala.package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("CSV field terminator can only be one character wide", DummyPosition$.MODULE$.apply(0), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

