/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.DummyPosition$;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.SignedOctalIntegerLiteral;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E2A!\u0001\u0002\u0001#\t9rj\u0019;bY&sG/Z4fe2KG/\u001a:bYR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!Y:u\u0015\t)a!\u0001\u0003we}\u0013$BA\u0004\t\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u0005\u000b\u0003!Ig\u000e^3s]\u0006d'BA\u0006\r\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011QBD\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+!\tqaY8n[>t7/\u0003\u0002\u0018)\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u0015q\u0002\u0001\"\u0003 \u0003M\t7o]3siN+W.\u00198uS\u000e,%O]8s)\r\u0001ce\f\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0005+:LG\u000fC\u0003(;\u0001\u0007\u0001&A\u0006tiJLgn\u001a,bYV,\u0007CA\u0015-\u001d\t\t#&\u0003\u0002,E\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tY#\u0005C\u00031;\u0001\u0007\u0001&\u0001\u0007feJ|'/T3tg\u0006<W\r")
public class OctalIntegerLiteralTest
extends CypherFunSuite {
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$OctalIntegerLiteralTest$$assertSemanticError(String stringValue, String errorMessage) {
        SignedOctalIntegerLiteral literal = new SignedOctalIntegerLiteral(stringValue, DummyPosition$.MODULE$.apply(4));
        SemanticCheckResult result = (SemanticCheckResult)literal.semanticCheck((Expression.SemanticContext)Expression.SemanticContext$.Simple$.MODULE$).apply((Object)SemanticState$.MODULE$.clean());
        TripleEqualsSupport.Equalizer<Seq> $org_scalatest_assert_macro_left = this.convertToEqualizer(result.errors());
        Vector $org_scalatest_assert_macro_right = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError(errorMessage, DummyPosition$.MODULE$.apply(4), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public OctalIntegerLiteralTest() {
        this.test("correctly parses octal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OctalIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer<Long> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new SignedOctalIntegerLiteral("022", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right = 18;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer<Long> $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new SignedOctalIntegerLiteral("00", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer<Long> $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(new SignedOctalIntegerLiteral("0734", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right3 = 476;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer<Long> $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(new SignedOctalIntegerLiteral("0034", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right4 = 28;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid octal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OctalIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$OctalIntegerLiteralTest$$assertSemanticError("0393", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$OctalIntegerLiteralTest$$assertSemanticError("03f4", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$OctalIntegerLiteralTest$$assertSemanticError("-0934", "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large octal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OctalIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$OctalIntegerLiteralTest$$assertSemanticError("077777777777777777777777777777", "integer is too large");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

