/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast;

import org.junit.runner.RunWith;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Create;
import org.neo4j.cypher.internal.compiler.v2_2.ast.EveryPath;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.NodePattern;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Pattern;
import org.neo4j.cypher.internal.compiler.v2_2.ast.PatternElement;
import org.neo4j.cypher.internal.compiler.v2_2.ast.PeriodicCommitHint;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Positional;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Positional$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Query;
import org.neo4j.cypher.internal.compiler.v2_2.ast.QueryPart;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Return;
import org.neo4j.cypher.internal.compiler.v2_2.ast.ReturnItems;
import org.neo4j.cypher.internal.compiler.v2_2.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.compiler.v2_2.ast.SingleQuery;
import org.neo4j.cypher.internal.compiler.v2_2.ast.StringLiteral;
import org.neo4j.cypher.internal.compiler.v2_2.ast.UnaliasedReturnItem;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001A2A!\u0001\u0002\u0001#\t1\u0002+\u001a:j_\u0012L7mQ8n[&$\b*\u001b8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011m\u001d;\u000b\u0005\u00151\u0011\u0001\u0002<3?JR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+9\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005]!\"\u0001\u0003$v]N+\u0018\u000e^3\u0011\u0005eQR\"\u0001\u0002\n\u0005m\u0011!A\u0003)pg&$\u0018n\u001c8bY\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u00033\u0001AC\u0001A\u0011*UA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0007eVtg.\u001a:\u000b\u0005\u0019r\u0011!\u00026v]&$\u0018B\u0001\u0015$\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013a\u000b\t\u0003Y9j\u0011!\f\u0006\u0003MQI!aL\u0017\u0003\u0017)+f.\u001b;Sk:tWM\u001d")
public class PeriodicCommitHintTest
extends FunSuite
implements Positional {
    private int currentPos;

    @Override
    public int currentPos() {
        return this.currentPos;
    }

    @Override
    public void currentPos_$eq(int x$1) {
        this.currentPos = x$1;
    }

    @Override
    public InputPosition pos() {
        return Positional$class.pos(this);
    }

    public PeriodicCommitHintTest() {
        Positional$class.$init$(this);
        this.test("negative values should fail", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PeriodicCommitHintTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InputPosition sizePosition = this.$outer.pos();
                String input = "-1";
                SignedDecimalIntegerLiteral value = new SignedDecimalIntegerLiteral(input, sizePosition);
                PeriodicCommitHint hint = new PeriodicCommitHint((Option)new Some((Object)value), this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)hint.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)result.errors().size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(((SemanticError)result.errors().head()).msg());
                String $org_scalatest_assert_macro_right2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Commit size error - expected positive value larger than zero, got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(((SemanticError)result.errors().head()).position());
                InputPosition $org_scalatest_assert_macro_right3 = sizePosition;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("no periodic commit size is ok", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PeriodicCommitHintTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PeriodicCommitHint hint = new PeriodicCommitHint((Option)None$.MODULE$, this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)hint.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)result.errors().size()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("positive values are OK", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PeriodicCommitHintTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InputPosition sizePosition = this.$outer.pos();
                String input = "1";
                SignedDecimalIntegerLiteral value = new SignedDecimalIntegerLiteral(input, sizePosition);
                PeriodicCommitHint hint = new PeriodicCommitHint((Option)new Some((Object)value), this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)hint.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)result.errors().size()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("queries with periodic commit and no updates are not OK", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PeriodicCommitHintTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SignedDecimalIntegerLiteral value = new SignedDecimalIntegerLiteral("1", this.$outer.pos());
                InputPosition periodicCommitPos = this.$outer.pos();
                PeriodicCommitHint hint = new PeriodicCommitHint((Option)new Some((Object)value), periodicCommitPos);
                StringLiteral literal = new StringLiteral("Hello world!", this.$outer.pos());
                UnaliasedReturnItem returnItem = new UnaliasedReturnItem((Expression)literal, "Hello world!", this.$outer.pos());
                ReturnItems returnItems = new ReturnItems(false, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnaliasedReturnItem[]{returnItem})), this.$outer.pos());
                Return returns = new Return(false, returnItems, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, this.$outer.pos());
                SingleQuery queryPart = new SingleQuery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Return[]{returns})), this.$outer.pos());
                Query query = new Query((Option)new Some((Object)hint), (QueryPart)queryPart, this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)query.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)result.errors().size()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(((SemanticError)result.errors().head()).msg());
                String $org_scalatest_assert_macro_right2 = "Cannot use periodic commit in a non-updating query";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(((SemanticError)result.errors().head()).position());
                InputPosition $org_scalatest_assert_macro_right3 = periodicCommitPos;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("queries with periodic commit and updates are OK", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PeriodicCommitHintTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SignedDecimalIntegerLiteral value = new SignedDecimalIntegerLiteral("1", this.$outer.pos());
                PeriodicCommitHint hint = new PeriodicCommitHint((Option)new Some((Object)value), this.$outer.pos());
                NodePattern nodePattern = new NodePattern((Option)None$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Option)None$.MODULE$, false, this.$outer.pos());
                Pattern pattern = new Pattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EveryPath[]{new EveryPath((PatternElement)nodePattern)})), this.$outer.pos());
                Create create = new Create(pattern, this.$outer.pos());
                SingleQuery queryPart = new SingleQuery((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Create[]{create})), this.$outer.pos());
                Query query = new Query((Option)new Some((Object)hint), (QueryPart)queryPart, this.$outer.pos());
                SemanticCheckResult result = (SemanticCheckResult)query.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)result.errors().size()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

