/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AliasedReturnItem;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.ast.ReturnItems;
import org.neo4j.cypher.internal.compiler.v2_2.ast.StringLiteral;
import org.neo4j.cypher.internal.compiler.v2_2.ast.UnaliasedReturnItem;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.enablers.Size$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00012A!\u0001\u0002\u0001#\ty!+\u001a;ve:LE/Z7t)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011m\u001d;\u000b\u0005\u00151\u0011\u0001\u0002<3?JR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!\u0003\u0007\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+!\tqaY8n[>t7/\u0003\u0002\u0018)\tq1)\u001f9iKJ4UO\\*vSR,\u0007CA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005i\t5\u000f^\"p]N$(/^2uS>tG+Z:u'V\u0004\bo\u001c:u\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002\u001a\u0001\u0001")
public class ReturnItemsTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final InputPosition pos;

    @Override
    public InputPosition pos() {
        return this.pos;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    @Override
    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport$class.withPos(this, expr);
    }

    @Override
    public Identifier ident(String name) {
        return AstConstructionTestSupport$class.ident(this, name);
    }

    @Override
    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport$class.propEquality(this, identifier, propKey, intValue);
    }

    public ReturnItemsTest() {
        AstConstructionTestSupport$class.$init$(this);
        this.test("should forbid aliased projections collisions, e.g., projecting more than one value to the same id", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral stringLiteral = (StringLiteral)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StringLiteral apply(InputPosition position) {
                        return new StringLiteral("a", position);
                    }
                });
                Identifier identifier = this.$outer.ident("n");
                Serializable item1 = new Serializable(this, stringLiteral, identifier){
                    public static final long serialVersionUID = 0L;
                    private final StringLiteral eta$0$1$1;
                    private final Identifier eta$1$1$1;

                    public final AliasedReturnItem apply(InputPosition position) {
                        return new AliasedReturnItem((Expression)this.eta$0$1$1, this.eta$1$1$1, position);
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                        this.eta$1$1$1 = eta$1$1$1;
                    }
                };
                StringLiteral stringLiteral2 = (StringLiteral)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StringLiteral apply(InputPosition position) {
                        return new StringLiteral("b", position);
                    }
                });
                Identifier identifier2 = this.$outer.ident("n");
                Serializable item2 = new Serializable(this, stringLiteral2, identifier2){
                    public static final long serialVersionUID = 0L;
                    private final StringLiteral eta$0$2$1;
                    private final Identifier eta$1$2$1;

                    public final AliasedReturnItem apply(InputPosition position) {
                        return new AliasedReturnItem((Expression)this.eta$0$2$1, this.eta$1$2$1, position);
                    }
                    {
                        this.eta$0$2$1 = eta$0$2$1;
                        this.eta$1$2$1 = eta$1$2$1;
                    }
                };
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AliasedReturnItem[]{(AliasedReturnItem)this.$outer.withPos(item1), (AliasedReturnItem)this.$outer.withPos(item2)}));
                Serializable items = new Serializable(this, seq){
                    public static final long serialVersionUID = 0L;
                    private final Seq eta$0$3$1;

                    public final ReturnItems apply(InputPosition position) {
                        return new ReturnItems(false, this.eta$0$3$1, position);
                    }
                    {
                        this.eta$0$3$1 = eta$0$3$1;
                    }
                };
                SemanticCheckResult result = (SemanticCheckResult)((ReturnItems)this.$outer.withPos(items)).semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                this.$outer.convertToStringShouldWrapper(((SemanticError)result.errors().head()).msg()).should(this.$outer.startWith().apply("Multiple result columns with the same name are not supported"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should forbid unaliased projections collisions, e.g., projecting more than one value to the same id", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral stringLiteral = (StringLiteral)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StringLiteral apply(InputPosition position) {
                        return new StringLiteral("a", position);
                    }
                });
                Serializable item1 = new Serializable(this, stringLiteral){
                    public static final long serialVersionUID = 0L;
                    private final StringLiteral eta$0$4$1;

                    public final UnaliasedReturnItem apply(InputPosition position) {
                        return new UnaliasedReturnItem((Expression)this.eta$0$4$1, "a", position);
                    }
                    {
                        this.eta$0$4$1 = eta$0$4$1;
                    }
                };
                StringLiteral stringLiteral2 = (StringLiteral)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StringLiteral apply(InputPosition position) {
                        return new StringLiteral("a", position);
                    }
                });
                Serializable item2 = new Serializable(this, stringLiteral2){
                    public static final long serialVersionUID = 0L;
                    private final StringLiteral eta$0$5$1;

                    public final UnaliasedReturnItem apply(InputPosition position) {
                        return new UnaliasedReturnItem((Expression)this.eta$0$5$1, "a", position);
                    }
                    {
                        this.eta$0$5$1 = eta$0$5$1;
                    }
                };
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnaliasedReturnItem[]{(UnaliasedReturnItem)this.$outer.withPos(item1), (UnaliasedReturnItem)this.$outer.withPos(item2)}));
                Serializable items = new Serializable(this, seq){
                    public static final long serialVersionUID = 0L;
                    private final Seq eta$0$6$1;

                    public final ReturnItems apply(InputPosition position) {
                        return new ReturnItems(false, this.eta$0$6$1, position);
                    }
                    {
                        this.eta$0$6$1 = eta$0$6$1;
                    }
                };
                SemanticCheckResult result = (SemanticCheckResult)((ReturnItems)this.$outer.withPos(items)).semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).should(this.$outer.have()).size(1L, Size$.MODULE$.sizeOfGenTraversable());
                this.$outer.convertToStringShouldWrapper(((SemanticError)result.errors().head()).msg()).should(this.$outer.startWith().apply("Multiple result columns with the same name are not supported"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not forbid aliased projections of the same expression with different names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReturnItemsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral stringLiteral = (StringLiteral)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StringLiteral apply(InputPosition position) {
                        return new StringLiteral("a", position);
                    }
                });
                Identifier identifier = this.$outer.ident("n");
                Serializable item1 = new Serializable(this, stringLiteral, identifier){
                    public static final long serialVersionUID = 0L;
                    private final StringLiteral eta$0$7$1;
                    private final Identifier eta$1$3$1;

                    public final AliasedReturnItem apply(InputPosition position) {
                        return new AliasedReturnItem((Expression)this.eta$0$7$1, this.eta$1$3$1, position);
                    }
                    {
                        this.eta$0$7$1 = eta$0$7$1;
                        this.eta$1$3$1 = eta$1$3$1;
                    }
                };
                StringLiteral stringLiteral2 = (StringLiteral)this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StringLiteral apply(InputPosition position) {
                        return new StringLiteral("a", position);
                    }
                });
                Identifier identifier2 = this.$outer.ident("m");
                Serializable item2 = new Serializable(this, stringLiteral2, identifier2){
                    public static final long serialVersionUID = 0L;
                    private final StringLiteral eta$0$8$1;
                    private final Identifier eta$1$4$1;

                    public final AliasedReturnItem apply(InputPosition position) {
                        return new AliasedReturnItem((Expression)this.eta$0$8$1, this.eta$1$4$1, position);
                    }
                    {
                        this.eta$0$8$1 = eta$0$8$1;
                        this.eta$1$4$1 = eta$1$4$1;
                    }
                };
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AliasedReturnItem[]{(AliasedReturnItem)this.$outer.withPos(item1), (AliasedReturnItem)this.$outer.withPos(item2)}));
                Serializable items = new Serializable(this, seq){
                    public static final long serialVersionUID = 0L;
                    private final Seq eta$0$9$1;

                    public final ReturnItems apply(InputPosition position) {
                        return new ReturnItems(false, this.eta$0$9$1, position);
                    }
                    {
                        this.eta$0$9$1 = eta$0$9$1;
                    }
                };
                SemanticCheckResult result = (SemanticCheckResult)((ReturnItems)this.$outer.withPos(items)).semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                this.$outer.convertToAnyShouldWrapper(result.errors()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

