/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.DummyPosition$;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.ast.UnsignedDecimalIntegerLiteral;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E2A!\u0001\u0002\u0001#\t\tSK\\:jO:,G\rR3dS6\fG.\u00138uK\u001e,'\u000fT5uKJ\fG\u000eV3ti*\u00111\u0001B\u0001\u0004CN$(BA\u0003\u0007\u0003\u00111(g\u0018\u001a\u000b\u0005\u001dA\u0011\u0001C2p[BLG.\u001a:\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011Q\u0003C\u0001\bG>lWn\u001c8t\u0013\t9BC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010\u0001\t\u0013y\u0012aE1tg\u0016\u0014HoU3nC:$\u0018nY#se>\u0014Hc\u0001\u0011'_A\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t!QK\\5u\u0011\u00159S\u00041\u0001)\u0003-\u0019HO]5oOZ\u000bG.^3\u0011\u0005%bcBA\u0011+\u0013\tY#%\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016#\u0011\u0015\u0001T\u00041\u0001)\u00031)'O]8s\u001b\u0016\u001c8/Y4f\u0001")
public class UnsignedDecimalIntegerLiteralTest
extends CypherFunSuite {
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$UnsignedDecimalIntegerLiteralTest$$assertSemanticError(String stringValue, String errorMessage) {
        UnsignedDecimalIntegerLiteral literal = new UnsignedDecimalIntegerLiteral(stringValue, DummyPosition$.MODULE$.apply(4));
        SemanticCheckResult result = (SemanticCheckResult)literal.semanticCheck((Expression.SemanticContext)Expression.SemanticContext$.Simple$.MODULE$).apply((Object)SemanticState$.MODULE$.clean());
        TripleEqualsSupport.Equalizer<Seq> $org_scalatest_assert_macro_left = this.convertToEqualizer(result.errors());
        Vector $org_scalatest_assert_macro_right = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError(errorMessage, DummyPosition$.MODULE$.apply(4), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public UnsignedDecimalIntegerLiteralTest() {
        this.test("correctly parses decimal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsignedDecimalIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer<Long> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(new UnsignedDecimalIntegerLiteral("22", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right = 22;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer<Long> $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(new UnsignedDecimalIntegerLiteral("0", DummyPosition$.MODULE$.apply(0)).value());
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for invalid decimal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsignedDecimalIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$UnsignedDecimalIntegerLiteralTest$$assertSemanticError("12g3", "invalid literal number");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$UnsignedDecimalIntegerLiteralTest$$assertSemanticError("923_23", "invalid literal number");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("throws error for too large decimal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UnsignedDecimalIntegerLiteralTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$UnsignedDecimalIntegerLiteralTest$$assertSemanticError("999999999999999999999999999", "integer is too large");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

